<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
$html = '';


$settings = $this->get_settings();
$align = $settings['align'];
$image_html = '';

if ($settings['iqonic_has_box_shadow'] == 'yes') {

	$align .= ' powerhour-box-shadow';
}

if($settings['design_style']=='style_1'){
?>

<div class="powerhour-counter powerhour-counter-style-1 <?php echo esc_attr($align); ?>">
    <?php if (!empty($settings['media_style'])) {
		if ($settings['media_style'] == 'image') {
			if (!empty($settings['image']['url'])) {
				$this->add_render_attribute('image', 'src', $settings['image']['url']);
				$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
				$this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
				$image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
			}
		} ?>
    <div class="powerhour-counter-icon">
        <?php
				echo $image_html;
				if ($settings['media_style'] == 'icon') {
					Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
				}
				?>
    </div>
    <?php } ?>
    <div class="counter-content">

        <<?php echo $settings['title_tag'] ?> class="powerhour-counter-info">
            <span class="timer" data-to="<?php echo  sprintf('%1$s', esc_html($settings['content'], 'iqonic-extension')); ?>"
                data-speed="5000"><?php echo sprintf('%1$s', esc_html($settings['content'], 'iqonic-extension')); ?></span>
            <span
                class="counter-after-content"><?php echo sprintf('%1$s', esc_html($settings['content_after_text'], 'iqonic-extension')); ?></span>
            <span
                class="counter-symbol"><?php echo sprintf('%1$s', esc_html($settings['content_symbol'], 'iqonic-extension')); ?></span>
        </<?php echo $settings['title_tag'] ?>>

        <h5 class="counter-title-text powerhour-heading-title">
            <?php echo esc_html($settings['section_title']); ?>
        </h5>
        
    </div>  
</div>
<?php } elseif($settings['design_style']=="style_2"){ ?>

<div class="powerhour-counter powerhour-counter-style-2">
    <div class="counter-content">
      <h3 class="powerhour-counter-info">
         <span class="timer" data-to="<?php echo  sprintf('%1$s', esc_html($settings['content'], 'iqonic-extension')); ?>" data-speed="5000"><?php echo sprintf('%1$s', esc_html($settings['content'], 'iqonic-extension')); ?></span>
         <span class="counter-after-content"><?php echo sprintf('%1$s', esc_html($settings['content_after_text'], 'iqonic-extension')); ?></span>
         <span class="counter-symbol"><?php echo sprintf('%1$s', esc_html($settings['content_symbol'], 'iqonic-extension')); ?></span>
      </h3>
   </div>
    <div class="powerhour-counter-icon">
    <?php if (!empty($settings['media_style'])) {
		if ($settings['media_style'] == 'image') {
			if (!empty($settings['image']['url'])) {
				$this->add_render_attribute('image', 'src', $settings['image']['url']);
				$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
				$this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
				$image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
			}
		} ?>
   <?php
				echo $image_html;
				if ($settings['media_style'] == 'icon') {
					Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
				}
				?>
      <?php } ?>
      <span class="counter-title-text powerhour-heading-title"><?php echo esc_html($settings['section_title']); ?></span>
   </div>
</div>
<?php }elseif($settings['design_style']=="style_3"){ ?>
    <div class="powerhour-counter powerhour-counter-style-3">
        <div class="powerhour-counter-icon">
            <div class="icon">
            <?php if (!empty($settings['media_style'])) {
                    if ($settings['media_style'] == 'image') {
                        if (!empty($settings['image']['url'])) {
                            $this->add_render_attribute('image', 'src', $settings['image']['url']);
                            $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
                            $this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
                            $image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                        }
                    } ?>
                    <?php
                        echo $image_html;
                        if ($settings['media_style'] == 'icon') {
                            Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
                        } ?>
            <?php } ?>
            </div>
            <div class="counter-content">
                <h4 class="powerhour-counter-info">
                    <span class="timer" data-to="<?php echo  sprintf('%1$s', esc_html($settings['content'], 'iqonic-extension')); ?>" data-speed="5000"><?php echo sprintf('%1$s', esc_html($settings['content'], 'iqonic-extension')); ?></span>
                    <span class="counter-after-content"><?php echo sprintf('%1$s', esc_html($settings['content_after_text'], 'iqonic-extension')); ?></span>
                    <span class="counter-symbol"><?php echo sprintf('%1$s', esc_html($settings['content_symbol'], 'iqonic-extension')); ?></span>
                </h4>
            </div>
            <span class="counter-title-text powerhour-heading-title"><?php echo esc_html($settings['section_title']); ?></span>
        </div>
    </div>
<?php } ?>