<?php

namespace Iqonic\Elementor\Elements\Counter;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic-Counter', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Counter', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-counter';
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'section_counters',
            [
                'label' => __('Counters Style', 'iqonic-extension'),
            ]
        );

        $this->add_control(
			'design_style',
			[
				'label' => __( 'Design Style', 'iqonic-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style_1',
				'options' => [
					'style_1'  => __( 'Style 1', 'iqonic-extension' ),
                    'style_2' => __( 'Style 2', 'iqonic-extension' ),
                    'style_3' => __( 'Style 3', 'iqonic-extension' )
				],
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'section',
            [
                'label' => __('Counter', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label' => __('Title', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('Add Your Title Text Here', 'iqonic-extension'),
            ]
        );
       
        $this->add_control(
            'content',
            [
                'label' => __('Counter Content', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('Enter Counter Figure Number', 'iqonic-extension'),
                'default' => __('100', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'content_after_text',
            [
                'label' => __('Counter After Content', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('Enter Counter After Text', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'content_symbol',
            [
                'label' => __('Counter Symbol', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('Enter Counter Symbol', 'iqonic-extension'),
                'default' => __('+', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'      => __('Title Tag', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'h3',
                'options'    => [

                    'h1'          => __('h1', 'iqonic-extension'),
                    'h2'          => __('h2', 'iqonic-extension'),
                    'h3'          => __('h3', 'iqonic-extension'),
                    'h4'          => __('h4', 'iqonic-extension'),
                    'h5'          => __('h5', 'iqonic-extension'),
                    'h6'          => __('h6', 'iqonic-extension'),
                ],
            ]
        );
        $this->add_control(
            'media_style',
            [
                'label'      => __('Icon / Image', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'icon',
                'options'    => [
                    'icon'          => __('Icon', 'iqonic-extension'),
                    'image'          => __('Image', 'iqonic-extension'),
                    'none'          => __('None', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'condition' => [
                    'media_style' => 'icon',
                ],
                'default' => [
                    'value' => 'fas fa-star'
                ],
            ]
        );
        $this->add_control(
            'image',
            [
                'label' => __('Choose Image', 'iqonic-extension'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'media_style' => 'image',
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'iqonic_has_box_shadow',
            [
                'label' => __('Box Shadow?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ],

                ],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
            ]
        );

       
        $this->end_controls_section();

        $this->start_controls_section(
            'section_C68vdQNDp9Ley31a3gsb',
            [
                'label' => __('Counter Content ', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('counter_tabs');
        $this->start_controls_tab(
            'tabs_P4JUaV0fNS5f6bWh1ZQ5',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'counter_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-counter, {{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 .counter-content',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_xcaiH8N2LfaIj3b56Grq',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'counter_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-counter:hover, {{WRAPPER}} .powerhour-counter.powerhour-counter-style-4:hover .counter-content ',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'counter_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-counter,{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 .counter-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}}  .powerhour-counter.powerhour-counter-style-4' => 'padding:0;',
                ],
            ]
        );

        $this->add_responsive_control(
            'counter_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-counter, {{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 .counter-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}}  .powerhour-counter.powerhour-counter-style-4' => 'margin:0;',
                ],

            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_aaQPp5E70aeHxBbJiuFl',
            [
                'label' => __('Title', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'counter_title_typography',
                'label' => __('Currency Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-counter .counter-title-text',
            ]
        );

        $this->start_controls_tabs('counter_title_tabs');
        $this->start_controls_tab(
            'tabs_0SW35aiga5bxLG8hF3Q8',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'counter_title_color',
            [
                'label' => __('Text Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter .counter-title-text' => 'color: {{VALUE}};',

                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_VXL5C9YfZbxId6ie2eab',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'counter_title_hover_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter:hover .counter-title-text' => 'color: {{VALUE}};',
                ],

            ]

        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'counter_title_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-counter .counter-title-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'counter_title_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-counter .counter-title-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_Rzcf1f33Atx14dLXZ6Tw',
            [
                'label' => __('Counter', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'counter_timer_typography',
                'label' => __('Currency Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-counter .timer,{{WRAPPER}} .powerhour-counter .counter-symbol,{{WRAPPER}} .powerhour-counter .counter-after-content',
            ]
        );

        $this->start_controls_tabs('counter_timer_tabs');
        $this->start_controls_tab(
            'tabs_Q436ETVNbixGeLZgaa26',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'counter_timer_color',
            [
                'label' => __('Text Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter .timer,{{WRAPPER}} .powerhour-counter .counter-symbol,{{WRAPPER}} .powerhour-counter .counter-after-content' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .counter-content .powerhour-counter-info:before'=> 'background:{{VALUE}}'

                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_a595ji49bpGaDfuAQtYk',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'counter_timer_hover_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter:hover .timer,{{WRAPPER}} .powerhour-counter:hover .counter-symbol,{{WRAPPER}} .powerhour-counter:hover .counter-after-content' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-counter:hover .counter-content .powerhour-counter-info:before'=> 'background:{{VALUE}}'
                ],

            ]

        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'counter_timer_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-counter .powerhour-counter-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'counter_timer_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-counter .powerhour-counter-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );




        $this->end_controls_section();

        
        $this->start_controls_section(
            'section_20bnaf9beBPYDN93bT0E',
            [
                'label' => __('Border', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'has_border',
            [
                'label'   => __('Set Custom Border?', 'iqonic-extension'),
                'type'    => Controls_Manager::SWITCHER,
                'default' => 'label_off',
                'yes'     => __('yes', 'iqonic-extension'),
                'no'      => __('no', 'iqonic-extension'),
            ]
        );
        $this->start_controls_tabs(
            'counter_border_tabs',
            [
                'condition' => ['has_border' => 'yes']
            ]
        );
        $this->start_controls_tab(
            'tabs_04kQ0L65UPMgbA74baDt',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'border_style',
            [
                'label'      => __('Border Style', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'none',
                'options'    => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge'  => __('ridge', 'iqonic-extension'),
                    'inset'  => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none'   => __('none', 'iqonic-extension'),
                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter, {{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 .counter-content' => 'border-style: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 ' => 'border:none;'

                ],
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter,{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 .counter-content' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 ' => 'border:none;'

                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter ,{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 .counter-content' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 ' => 'border:none;'
                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => __('Border radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter,{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 .counter-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4 ' => 'border:none;'
                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_boFxnZ5gNIbPbBGkalbd',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'border_hover_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),
                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter:hover,{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4:hover .counter-content' => 'border-style: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4:hover' => 'border:none;'

                ],
            ]
        );

        $this->add_control(
            'border_hover_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter:hover,{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4:hover .counter-content' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4:hover' => 'border:none;'

                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'border_hover_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter:hover,{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4:hover .counter-content' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4:hover' => 'border:none;'
                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'border_hover_radius',
            [
                'label' => __('Border radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-counter:hover,{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4:hover .counter-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-counter.powerhour-counter-style-4:hover' => 'border:none;'
                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
                /* Icon or Image start */
                $this->start_controls_section(
                    'section_285gU1520',
                    [
                        'label' => __('Icon/Image', 'iqonic-extension'),
                        'tab' => Controls_Manager::TAB_STYLE,
                    ]
                );
        
                $this->start_controls_tabs('counterbox_icon_tabs');
                $this->start_controls_tab(
                    'tabs_jeBef2kCfHObvih40638',
                    [
                        'label' => __('Normal', 'iqonic-extension'),
                    ]
                );
        
        
                $this->add_control(
                    'icon_color',
                    [
                        'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter .counter-box-img i,{{WRAPPER}} .powerhour-counter .counter-box-img i path' => 'fill: {{VALUE}}; color: {{VALUE}};',
                            '{{WRRAPER}} .powerhour-counter-style-1 .powerhour-counter-icon i' => 'color: {{VALUE}}'
                        ],
                        'condition' => [
                            'media_style!' => 'image',
                        ],
                    ]
        
                );
        
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'powerhour_counterbox_icon_background',
                        'label' => __('Background', 'iqonic-extension'),
                        'types' => ['classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .powerhour-counter-style-1 .powerhour-counter-icon, {{WRAPPER}} .powerhour-counter.powerhour-counter-style-7 .img-bg',
                    ]
                );
        
        
                $this->add_control(
                    'powerhour_counterbox_has_border',
                    [
                        'label' => __('Set Custom Border?', 'iqonic-extension'),
                        'type' => Controls_Manager::SWITCHER,
                        'default' => 'no',
                        'yes' => __('yes', 'iqonic-extension'),
                        'no' => __('no', 'iqonic-extension'),
                    ]
                );
        
                $this->add_control(
                    'powerhour_counterbox_icon_border_style',
                    [
                        'label' => __('Border Style', 'iqonic-extension'),
                        'type' => Controls_Manager::SELECT,
                        'condition' => ['powerhour_counterbox_has_border' => ['yes']],
                        'default' => 'none',
                        'options' => [
                            'solid'  => __('Solid', 'iqonic-extension'),
                            'dashed' => __('Dashed', 'iqonic-extension'),
                            'dotted' => __('Dotted', 'iqonic-extension'),
                            'double' => __('Double', 'iqonic-extension'),
                            'outset' => __('outset', 'iqonic-extension'),
                            'groove' => __('groove', 'iqonic-extension'),
                            'ridge' => __('ridge', 'iqonic-extension'),
                            'inset' => __('inset', 'iqonic-extension'),
                            'hidden' => __('hidden', 'iqonic-extension'),
                            'none' => __('none', 'iqonic-extension'),
        
                        ],
        
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter-style-1 .powerhour-counter-icon' => 'border-style:{{VALUE}};',
        
                        ],
                    ]
                );
        
                $this->add_control(
                    'powerhour_counterbox_icon_border_color',
                    [
                        'label' => __('Border Color', 'iqonic-extension'),
                        'condition' => ['powerhour_counterbox_has_border' => ['yes']],
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter-style-1 .powerhour-counter-icon' => 'border-color: {{VALUE}};',
                        ],
        
        
                    ]
                );
        
                $this->add_control(
                    'powerhour_counterbox_icon_border_width',
                    [
                        'label' => __('Border Width', 'iqonic-extension'),
                        'condition' => ['powerhour_counterbox_has_border' => ['yes']],
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => ['px', '%'],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter-style-1 .powerhour-counter-icon' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
        
                    ]
                );
        
                $this->add_control(
                    'powerhour_counterbox_icon_border_radius',
                    [
                        'label' => __('Border Radius', 'iqonic-extension'),
                        'condition' => ['powerhour_counterbox_has_border' => ['yes']],
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => ['px', '%'],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter-style-1 .powerhour-counter-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
        
                    ]
                );
                $this->end_controls_tab();
        
                $this->start_controls_tab(
                    'tabs_aJ0C3kdUL5G4tW12awyR',
                    [
                        'label' => __('Hover', 'iqonic-extension'),
                    ]
                );
        
                $this->add_control(
                    'icon_hover_color',
                    [
                        'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                        'type' => Controls_Manager::COLOR,
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter:hover .counter-box-img i,{{WRAPPER}} .powerhour-counter:hover .counter-box-img i path,{{WRAPPER}} .powerhour-counter.active .counter-box-img i,{{WRAPPER}} .powerhour-counter.active .counter-box-img i path' => 'fill: {{VALUE}}; color: {{VALUE}};',
                            '{{WRRAPER}} .powerhour-counter-style-1:hover .powerhour-counter-icon i' => 'color: {{VALUE}}'
                        ],
                        'condition' => [
                            'media_style!' => 'image',
                        ],
        
                    ]
                );
        
                $this->add_group_control(
                    Group_Control_Background::get_type(),
                    [
                        'name' => 'powerhour_counterbox_icon_hover_background',
                        'label' => __('Hover Background', 'iqonic-extension'),
                        'types' => ['classic', 'gradient'],
                        'selector' => '{{WRAPPER}} .powerhour-counter-style-1:hover .powerhour-counter-icon,{{WRAPPER}} .powerhour-counter.active .counter-box-img',
                    ]
                );
        
                $this->add_control(
                    'powerhour_counterbox_hover_has_border',
                    [
                        'label' => __('Set Custom Border?', 'iqonic-extension'),
                        'type' => Controls_Manager::SWITCHER,
                        'default' => 'no',
                        'yes' => __('yes', 'iqonic-extension'),
                        'no' => __('no', 'iqonic-extension'),
                    ]
                );
        
                $this->add_control(
                    'powerhour_counterbox_icon_hover_border_style',
                    [
                        'label' => __('Border Style', 'iqonic-extension'),
                        'type' => Controls_Manager::SELECT,
                        'default' => 'none',
                        'options' => [
                            'solid'  => __('Solid', 'iqonic-extension'),
                            'dashed' => __('Dashed', 'iqonic-extension'),
                            'dotted' => __('Dotted', 'iqonic-extension'),
                            'double' => __('Double', 'iqonic-extension'),
                            'outset' => __('outset', 'iqonic-extension'),
                            'groove' => __('groove', 'iqonic-extension'),
                            'ridge' => __('ridge', 'iqonic-extension'),
                            'inset' => __('inset', 'iqonic-extension'),
                            'hidden' => __('hidden', 'iqonic-extension'),
                            'none' => __('none', 'iqonic-extension'),
                        ],
                        'condition' => ['powerhour_counterbox_hover_has_border' => ['yes']],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter-style-1:hover .powerhour-counter-icon ,{{WRAPPER}} .powerhour-counter.active .counter-box-img' => 'border-style:{{VALUE}};',
                        ],
                    ]
                );
        
                $this->add_control(
                    'powerhour_counterbox_icon_hover_border_color',
                    [
                        'label' => __('Border Color', 'iqonic-extension'),
                        'type' => Controls_Manager::COLOR,
                        'condition' => ['powerhour_counterbox_hover_has_border' => ['yes']],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter-style-1:hover .powerhour-counter-icon ,{{WRAPPER}} .powerhour-counter.active .counter-box-img' => 'border-color: {{VALUE}};',
                        ],
                    ]
                );
        
        
                $this->add_control(
                    'powerhour_counterbox_icon_hover_border_width',
                    [
                        'label' => __('Border Width', 'iqonic-extension'),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => ['px', '%'],
                        'condition' => ['powerhour_counterbox_hover_has_border' => ['yes']],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter-style-1:hover .powerhour-counter-icon,{{WRAPPER}} .powerhour-counter.active .counter-box-img' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );
        
                $this->add_control(
                    'powerhour_counterbox_icon_hover_border_radius',
                    [
                        'label' => __('Border Radius', 'iqonic-extension'),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => ['px', '%'],
                        'condition' => ['powerhour_counterbox_hover_has_border' => ['yes']],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter-style-1:hover .powerhour-counter-icon ,{{WRAPPER}} .powerhour-counter.active .counter-box-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
                    ]
                );
        
                $this->end_controls_tab();
                $this->end_controls_tabs();
        
                $this->add_responsive_control(
                    'icon_size',
                    [
                        'label' => __('Icon Size', 'iqonic-extension'),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'condition' => ['media_style' => ['icon']],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                                'step' => 5,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter .counter-box-img i,{{WRAPPER}} .powerhour-counter .powerhour-counter-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
        
        
                $this->add_responsive_control(
                    'icon_width',
                    [
                        'label' => __('Width', 'iqonic-extension'),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                                'step' => 5,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter .powerhour-counter-icon img,{{WRAPPER}} .powerhour-counter .counter-box-img img,{{WRAPPER}} .powerhour-counter .powerhour-counter-icon svg' => 'width: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
        
                $this->add_responsive_control(
                    'icon_height',
                    [
                        'label' => __('Height', 'iqonic-extension'),
                        'type' => Controls_Manager::SLIDER,
                        'size_units' => ['px', '%'],
                        'range' => [
                            'px' => [
                                'min' => 0,
                                'max' => 1000,
                                'step' => 5,
                            ],
                            '%' => [
                                'min' => 0,
                                'max' => 100,
                            ],
                        ],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter .powerhour-counter-icon img,{{WRAPPER}} .powerhour-counter .counter-box-img, {{WRAPPER}} .powerhour-counter .powerhour-counter-icon svg' => 'height: {{SIZE}}{{UNIT}};',
                            '{{WRAPPER}} .powerhour-counter .counter-box-img i,{{WRAPPER}} .powerhour-counter .counter-box-img i' => 'line-height: {{SIZE}}{{UNIT}};',
                        ],
                    ]
                );
        
        
                $this->add_responsive_control(
                    'powerhour_counterbox_icon_padding',
                    [
                        'label' => __('Padding', 'iqonic-extension'),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => ['px', '%'],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter .powerhour-counter-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
        
                    ]
                );
        
                $this->add_responsive_control(
                    'powerhour_counterbox_icon_margin',
                    [
                        'label' => __('Margin', 'iqonic-extension'),
                        'type' => Controls_Manager::DIMENSIONS,
                        'size_units' => ['px', '%'],
                        'selectors' => [
                            '{{WRAPPER}} .powerhour-counter .powerhour-counter-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                        ],
        
                    ]
                );
        
        
                $this->end_controls_section();
        
                /* Icon or Image end */
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Counter/render.php';
    }
}
