<?php

namespace Elementor;

use Elementor\Plugin;

if (!defined('ABSPATH')) exit;



$settings = $this->get_settings();
$tabs = $this->get_settings_for_display('tabs');
$col = 'powerhour-client-col-3';

$align = '';

if ($settings['iqonic_has_box_shadow'] == 'yes') {

    $align .= ' powerhour-box-shadow';
}
$image_html = '';  ?>

<div class="powerhour-client">

    <?php
    if ($settings['client_style'] === "2") {
        $col = 'powerhour-client-col-2';
    }
    if ($settings['client_style'] === "3") {
        $col = 'powerhour-client-col-3';
    }
    if ($settings['client_style'] === "4") {
        $col = 'powerhour-client-col-4';
    }
    if ($settings['client_style'] === "5") {
        $col = 'powerhour-client-col-5';
    }
    if ($settings['client_style'] === "6") {
        $col = 'powerhour-client-col-6';
    }
    echo '<ul class="' . esc_attr($col) . ' powerhour-client-grid">';
    foreach ($tabs as $index => $item) {
        if ($item['media_style'] == 'image') {
            if (!empty($item['image']['url'])) {
                $this->add_render_attribute('image', 'src', $item['image']['url']);
                $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($item['image']));
                $this->add_render_attribute('image', 'title', Control_Media::get_image_title($item['image']));
                $image_html = Group_Control_Image_Size::get_attachment_image_html($item, 'thumbnail', 'image');
            }
        }
    ?>
        <li class="elementor-repeater-item-<?php echo $item['_id']; ?> <?php echo esc_attr($align, 'iqonic-extension') ?>">

            <?php
            if ($item['media_style'] == 'icon') {
                Icons_Manager::render_icon($item['selected_icon'], ['aria-hidden' => 'true']);
            } else {
                echo $image_html;
            }
            ?>
        </li>

    <?php
    }
    ?>
   
    <?php
    echo '</ul>';
    ?>
</div>