<?php

namespace Iqonic\Elementor\Elements\Client;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_client', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Client', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }
    protected function register_controls()
    {

        $this->start_controls_section(
            'section_client',
            [
                'label' => __('Client Post', 'iqonic-extension'),

            ]
        );

        $this->add_control(
            'client_style',
            [
                'label'      => __('Client Style', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => '5',
                'options'    => [
                    '2' => __('Client 2 Columns', 'iqonic-extension'),
                    '3' => __('Client 3 Columns', 'iqonic-extension'),
                    '4' => __('Client 4 Columns', 'iqonic-extension'),
                    '5' => __('Client 5 Columns', 'iqonic-extension'),
                    '6' => __('Client 6 Columns', 'iqonic-extension'),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'media_style',
            [
                'label'      => __('Icon / Image', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'image',
                'options'    => [

                    'icon'          => __('Icon', 'iqonic-extension'),
                    'image'          => __('Image', 'iqonic-extension'),

                ],
            ]
        );
        $repeater->add_control(
            'selected_icon',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'condition' => [
                    'media_style' => 'icon',
                ],
                'default' => [
                    'value' => 'fas fa-star'

                ],
            ]
        );
        $repeater->add_control(
            'image',
            [
                'label' => __('Choose Image', 'iqonic-extension'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'media_style' => 'image',
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'client_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-client {{CURRENT_ITEM}}.item,{{WRAPPER}} .powerhour-client li{{CURRENT_ITEM}}',
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label' => __('List Items', 'iqonic-extension'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'iqonic_has_box_shadow',
            [
                'label' => __('Box Shadow?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->end_controls_section();


        /* Client Box Start*/

        $this->start_controls_section(
            'section_jpdZo4adyfPfER8bqVQF',
            [
                'label' => __('Client Box', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('powerhour_client_box_tabs');
        $this->start_controls_tab(
            'tabs_Ad2RWVvjUsS088PCabdf',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_client_box_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-client',
            ]
        );


        $this->add_control(
            'powerhour_client_box_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'powerhour_client_box_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'condition' => [
                    'powerhour_client_box_has_border' => 'yes',
                ],
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-client' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'powerhour_client_box_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client' => 'border-color: {{VALUE}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_client_box_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_client_box_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_m3r8Z6h2ja8xSFVid4z8',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_client_box_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-client:hover,{{WRAPPER}} .powerhour-client.active',
            ]
        );


        $this->add_control(
            'powerhour_client_box_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'powerhour_client_box_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-client:hover,{{WRAPPER}} .powerhour-client.active' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'powerhour_client_box_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client:hover,{{WRAPPER}} .powerhour-client.active' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'powerhour_client_box_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client:hover,{{WRAPPER}} .powerhour-client.active' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_client_box_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client:hover,{{WRAPPER}} .powerhour-client.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();



        $this->add_responsive_control(
            'powerhour_client_box_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-client' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'powerhour_client_box_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-client' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );


        $this->end_controls_section();

        /* Client Box End*/

        /* Client List Start*/

        $this->start_controls_section(
            'section_avb386YbL4372yhufPre',
            [
                'label' => __('Client List', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('powerhour_client_list_tabs');
        $this->start_controls_tab(
            'tabs_j4aK4oUfabgwx9Zmv8eC',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_client_list_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-client li,{{WRAPPER}} .powerhour-client .item',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'powerhour_client_list_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-client li,{{WRAPPER}} .powerhour-client .item',
            ]
        );


        $this->add_control(
            'powerhour_client_list_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'powerhour_client_list_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'condition' => [
                    'powerhour_client_list_has_border' => 'yes',
                ],
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-client li,{{WRAPPER}} .powerhour-client .item ' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'powerhour_client_list_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_list_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client li,{{WRAPPER}} .powerhour-client .item' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'powerhour_client_list_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_list_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client li,{{WRAPPER}} .powerhour-client .item' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_client_list_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_list_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client li,{{WRAPPER}} .powerhour-client .item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_Xl7FbE1e30MZJaQn08m7',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_client_list_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-client li:hover, {{WRAPPER}} .powerhour-client .item:hover ',
            ]
        );


        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'powerhour_client_list_hover_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-client li:hover, {{WRAPPER}} .powerhour-client .item:hover',
            ]
        );

        $this->add_control(
            'powerhour_client_list_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'powerhour_client_list_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_list_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-client li:hover, {{WRAPPER}} .powerhour-client .item:hover' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'powerhour_client_list_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_list_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client li:hover, {{WRAPPER}} .powerhour-client .item:hover' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'powerhour_client_list_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_list_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client li:hover, {{WRAPPER}} .powerhour-client .item:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_client_list_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_list_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-client li:hover, {{WRAPPER}} .powerhour-client .item:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();



        $this->add_responsive_control(
            'powerhour_client_list_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-client li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'powerhour_client_list_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-client li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );


        $this->end_controls_section();

        /* Client list End*/

        
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Client/render.php';
    }
}
