<?php

namespace Iqonic\Elementor\Elements\Cart;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_cart';
    }

    public function get_title()
    {
        return __('Layouts: Cart', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-layouts-extension'];
    }

    public function get_icon()
    {
        return 'eicon-cart';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_sc_layouts_cart',
            [
                'label' => __('Layouts: Cart', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-shopping-cart',
                    'library' => 'solid',
                ],
            ]
        );

        $this->end_controls_section();
        // Cart Style Section End

        //Icon
        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
			'btn_size',
			[
				'label' => esc_html__( 'Button Size', 'iqonic-extension' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ,'em'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .cart-btn .powerhour-cart a' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);
        $this->add_control(
			'btn_radius',
			[
				'label' => esc_html__( 'Button Radius', 'iqonic-extension' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ,'em'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 500,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .cart-btn .powerhour-cart a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);


        $this->start_controls_tabs('icon_tabs');
        $this->start_controls_tab(
            'tabs_icon_normal',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );


        $this->add_control(
            'icon_bg_color',
            [
                'label' => __('Choose Background Color ', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart svg,{{WRAPPER}} .powerhour-cart i,{{WRAPPER}} .powerhour-cart svg path, {{WRAPPER}} .powerhour-cart i, {{WRAPPER}} .powerhour-cart svg path' => 'fill: {{VALUE}}; color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_icon_hover',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'icon_hover_bg_color',
            [
                'label' => __('Choose Background Hover Color ', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'icon_hover_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart:hover svg,{{WRAPPER}} .powerhour-cart .dropdown-cart:hover svg path,{{WRAPPER}} .powerhour-cart .dropdown-cart:hover i' => 'fill: {{VALUE}}; color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart i,{{WRAPPER}} .powerhour-cart svg' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'icon_width',
            [
                'label' => __('Width', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart svg,{{WRAPPER}} .powerhour-cart i, {{WRAPPER}} .powerhour-cart svg' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_height',
            [
                'label' => __('Height', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart svg,{{WRAPPER}} .powerhour-cart i, {{WRAPPER}} .powerhour-cart svg' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Count
        $this->start_controls_section(
            'section_count_style',
            [
                'label' => __('Count', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->start_controls_tabs('count_tabs');
        $this->start_controls_tab(
            'tabs_count_normal',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'count_color',
            [
                'label' => __('Choose color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart .count, {{WRAPPER}} .powerhour-cart .basket-item-count .cart-items-count.count' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_count_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-cart .dropdown-cart .count, {{WRAPPER}} .basket-item-count',
            ]
        );
        $this->add_control(
            'powerhour_icon_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'powerhour_icon_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'condition' => ['powerhour_icon_has_border' => ['yes']],
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart .count' => 'border-style:{{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'powerhour_icon_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => ['powerhour_icon_has_border' => ['yes']],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart .count' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'powerhour_icon_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => ['powerhour_icon_has_border' => ['yes']],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart .count' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_icon_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => ['powerhour_icon_has_border' => ['yes']],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart .count' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_count_hover',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'count_hover_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-cart .dropdown-cart:hover .count' => 'fill: {{VALUE}}; color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_count_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}}  .powerhour-cart .dropdown-cart:hover .count',
            ]
        );

        $this->add_control(
            'powerhour_count_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'powerhour_icon_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],
                'condition' => ['powerhour_count_hover_has_border' => ['yes']],

                'selectors' => [
                    '{{WRAPPER}}  .powerhour-cart .dropdown-cart:hover .count' => 'border-style:{{VALUE}};',


                ],
            ]
        );

        $this->add_control(
            'powerhour_icon_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['powerhour_count_hover_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-cart .dropdown-cart:hover .count' => 'border-color: {{VALUE}};',
                ],


            ]
        );


        $this->add_control(
            'powerhour_icon_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => ['powerhour_count_hover_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-cart .dropdown-cart:hover .count' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_icon_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => ['powerhour_count_hover_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-cart .dropdown-cart:hover .count' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'count_size',
            [
                'label' => __('Font Size', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart .count' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'count_width',
            [
                'label' => __('Width', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart .count' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'count_height',
            [
                'label' => __('Height', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-cart .dropdown-cart .count' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        if ( class_exists( 'WooCommerce' ) ) {
            require 'render.php';
        }
    }
}
