<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
$html = '';

$settings = $this->get_settings_for_display();
$settings = $this->get_settings();

$this->add_render_attribute('powerhour_container', 'class', 'powerhour-btn-container');

$icon = '';
if (!empty($settings['button_text'])) {
    if ($settings['button_type'] === "default") {
        $this->add_render_attribute('powerhour_class', 'class', 'powerhour-button');
        $html .= '<span class="text-btn">' . esc_html($settings['button_text']) . '</span>';
    } elseif ($settings['button_type'] === "linked") {
        $this->add_render_attribute('powerhour_class', 'class', 'powerhour-btn-link');
        $html .= '<span class="text-btn"> ' . esc_html($settings['button_text']) . '</span>';
    }
}
if ($settings['link_type'] == 'dynamic') {
    $url =  get_permalink(get_page_by_path($settings['dynamic_link']));

    $this->add_render_attribute('powerhour_class', 'href', esc_url($url));
} else {
    if ($settings['link']['url']) {
        $url = $settings['link']['url'];
        $this->add_render_attribute('powerhour_class', 'href', esc_url($url));

        if ($settings['link']['is_external']) {
            $this->add_render_attribute('powerhour_class', 'target', '_blank');
        }

        if ($settings['link']['nofollow']) {
            $this->add_render_attribute('powerhour_class', 'rel', 'nofollow');
        }
    }
}
$url = '';
?>

<div <?php echo $this->get_render_attribute_string('powerhour_container') ?>>

    <a <?php echo $this->get_render_attribute_string('powerhour_class') ?>>
        <?php
        echo wp_kses_post($html); ?>
    </a>
</div>