<?php

namespace Elementor;

use Elementor\Plugin;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();

$thought_image = get_field('field_thought_icon');

$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$fields = get_fields('group_rgdfgdfgdfdfg');
$fields = get_fields('group_servicer8t81');

$cat = '';
if (isset($settings['blog_cat']) && !empty($settings['blog_cat'])) {
    $cat = implode(',', $settings['blog_cat']);
}

$args = array(
    'post_type'         => 'post',
    'post_status'       => 'publish',
    'paged'             => $paged,
    'category_name'     => $cat,
    'order'             => $settings['order'],
    'suppress_filters'  => 0,
    'posts_per_page'    => $settings['posts_per_page']['size']
);

$align = $settings['align'] ?? '';

// blog layouts	
$blog_layout = '';
$blog_art = '';
$blog_layout = ' powerhour-default-blog-style-2-grid';
$blog_art = ' powerhour-blog-article-style';
if (isset($settings['blog_style']) && $settings['blog_style'] > 2) {
    $blog_layout = ' powerhour-default-blog-style-2-grid';
} else if (isset($settings['blog_style']) && $settings['blog_style'] === '1') {
    if (isset($settings['desk_number']) && $settings['desk_number'] > 1) {
        $blog_layout = ' powerhour-default-blog-style-2-grid';
    }
}
$align .= $blog_layout;

global $post;

$wp_query = new \WP_Query($args);

$i = 0;
$class_hidden = '';
$class_with_loadmore = '';
$data_loadmore_item = '';
$loadmore_btn = '';
$display_data = 'powerhour-display_blog';
$display_loadmore_btn = 'display:none';
if (isset($settings['loadmore_button']) && $settings['loadmore_button'] === 'yes') {
    $class_hidden = ' loadmore-hidden-items';
    $class_with_loadmore = 'display:block';
    $display_data = ' powerhour-with-loadmore';
    $data_loadmore_item = $settings['posts_per_loadmore']['size'];
    $display_loadmore_btn = 'display:block';
}

$post_per_page = $settings['posts_per_page'];

?>
<div class=" <?php echo esc_attr($align, 'iqonic-extension') ?>">
    <?php
    if ($settings['blog_style'] === '1') {
        $desk = $settings['desk_number'];
        $lap = $settings['lap_number'];
        $tab = $settings['tab_number'];
        $mob = $settings['mob_number'];


        $this->add_render_attribute('slider', 'data-items', $settings['desk_number']);
        $this->add_render_attribute('slider', 'data-items-laptop', $settings['lap_number']);
        $this->add_render_attribute('slider', 'data-items-tab', $settings['tab_number']);
        $this->add_render_attribute('slider', 'data-items-mobile', $settings['mob_number']);
        $this->add_render_attribute('slider', 'data-items-mobile-sm', $settings['mob_number']);
        $this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
        $this->add_render_attribute('slider', 'data-loop', $settings['loop']);
        $this->add_render_attribute('slider', 'data-dots', $settings['dots']);
        $this->add_render_attribute('slider', 'data-nav', $settings['nav-arrow']);
        $this->add_render_attribute('slider', 'data-margin', $settings['margin']['size']);
    ?>
        <div class="blog-carousel owl-carousel" <?php echo $this->get_render_attribute_string('slider') ?>>
            <?php
            if ($wp_query->have_posts()) {
                while ($wp_query->have_posts()) {
                    $wp_query->the_post();
                    $full_image  = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");
                    $term_list   = wp_get_post_terms(get_the_ID(), 'category');
                    $slugs       = array();
                    foreach ($term_list as $term) {
                        $slugs[] = $term->slug;
                    } ?>
                    <div class="powerhour-blog-box">
                        <?php
                        if (has_post_thumbnail()) { ?>
                            <div class="powerhour-blog-image">
                                <?php
                                echo sprintf('<img src="%1$s" alt="iqonic-blog"/>', esc_url($full_image[0], 'iqonic-extension'));

                                //post date
                                $archive_year  = get_the_time('Y', $wp_query->ID);
                                $archive_month = get_the_time('m', $wp_query->ID);
                                $archive_day   = get_the_time('d', $wp_query->ID);
                                if ($wp_query->post_date) {
                                    $date = date_create($wp_query->post_date);
                                } ?>
                                <div class="list-inline-item blog-date">
                                    <?php echo sprintf("%s", iqonic_blog_time_link()); ?>
                                </div>
                            </div>
                        <?php
                        } ?>
                        <div class="powerhour-blog-details">
                            <div class="powerhour-blog-meta">
                                <ul class="list-inline">
                                    <li class="list-inline-item blog-author">
                                        <?php esc_html_e("By:", 'iqonic-extension'); ?>
                                        <a href="<?php echo get_the_author_meta($wp_query->ID) ?>" class="powerhour-user"><?php echo get_the_author($wp_query->ID); ?></a>
                                    </li>
                                    <li>
                                        <?php
                                        $postcat = get_the_category();
                                        $i = 1;
                                        if ($postcat) {
                                            echo '<div class="blog-catgeory">';
                                            foreach ($postcat as $cat) {
                                                if ($i === count($postcat)) {
                                                    $cat_name = $cat->name;
                                                } else {
                                                    $cat_name = $cat->name;
                                                }
                                                $i++;
                                        ?>
                                                <a class="iqonic-port-cat" href="<?php echo get_category_link($cat->cat_ID) ?>"><?php echo esc_html($cat_name); ?></a>
                                        <?php
                                            }
                                            echo '</div>';
                                        } ?>
                                    </li>
                                </ul>
                            </div>

                            <div class="blog-title">
                                <a class="button-link" href="<?php echo sprintf("%s", esc_url(get_permalink($wp_query->ID))); ?>">
                                    <<?php echo esc_attr($settings['title_tag']); ?> class="blog-text powerhour-heading-title"><?php echo sprintf("%s", esc_html__(get_the_title($wp_query->ID), 'iqonic-extension')); ?></<?php echo esc_attr($settings['title_tag']); ?>>
                                </a>
                            </div>

                            <div class="powerhour-blogmain">
                                <p><?php echo sprintf("%s", get_the_excerpt($wp_query->ID)); ?></p>
                                <?php if (!empty($settings['button_text'])) {
                                    require  IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-btn-render-control.php';
                                } ?>
                            </div>
                        </div>
                    </div>
            <?php
                }
            }
            wp_reset_postdata();
            ?>
        </div>
        <!-- Blog Grid -->
    <?php
    } else if ($settings['blog_style'] == 'blog-grid') { ?>
        <div class="powerhour-blog-list-1 powerhour-loadmore <?php echo esc_html($class_with_loadmore, 'iqonic-extension'); ?>" data-loadmore-item='<?php echo esc_html($data_loadmore_item, 'iqonic-extension'); ?>' data-loadmore-count="<?php echo esc_html($data_loadmore_item, 'iqonic-extension'); ?>">
            <div class="powerhour-loadmore-block">
                <?php
                if (isset($settings['blog_cat']) && !empty($settings['blog_cat'])) {
                    $terms = $settings['blog_cat'];
                } else {
                    $terms = get_terms(array('taxonomy' => 'category'));
                }
                foreach ($terms as $term) {
                    if (isset($settings['blog_cat']) && !empty($settings['blog_cat'])) {
                        $term = get_term_by('slug', $term, 'category');
                    }

                    $args = array(
                        'post_type' => 'post',
                        'posts_per_page' => $post_per_page['size'],
                        'category_name'  => $term->slug,
                        'order'         => $settings['order'],
                    );

                    $wp_query  = new \WP_Query($args);
                ?>
                    <div class="powerhour-blogs-list">
                        <?php
                        if ($wp_query->have_posts()) {
                            while ($wp_query->have_posts()) {
                                $wp_query->the_post();
                                $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");
                                $term_list = wp_get_post_terms(get_the_ID(), 'category');
                                $slugs = array();
                                foreach ($term_list as $term) {
                                    $slugs[] = $term->slug;
                                }
                                $m_grid = "";
                                $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "power-hour-s25");
                        ?>
                                <div class="powerhour-loadmore-item powerhour-blog-box powerhour-blog-list-item <?php echo implode(' ', $slugs); ?><?php echo esc_html($class_hidden, 'iqonic-extension'); ?>">
                                    <?php
                                    if (has_post_thumbnail()) { ?>
                                        <div class="powerhour-blog-image">
                                            <?php
                                            echo sprintf('<img src="%1$s" alt="iqonic-blog"/>', esc_url($full_image[0], 'iqonic-extension'));
                                            ?>
                                        </div>
                                    <?php
                                    } ?>
                                    <div class="powerhour-blog-details">
                                        <div class="powerhour-blog-meta">
                                            <ul class="list-inline">
                                                <li class="list-inline-item blog-author">
                                                    <?php esc_html_e("By:", 'iqonic-extension'); ?>
                                                    <a href="<?php echo get_the_author_meta($wp_query->ID) ?>" class="powerhour-user"><?php echo get_the_author($wp_query->ID); ?></a>
                                                </li>
                                                <li>
                                                    <?php
                                                    $postcat = get_the_category();
                                                    $i = 1;
                                                    if ($postcat) {
                                                        echo '<div class="blog-catgeory">';
                                                        foreach ($postcat as $cat) {
                                                            if ($i === count($postcat)) {
                                                                $cat_name = $cat->name;
                                                            } else {
                                                                $cat_name = $cat->name;
                                                            }
                                                            $i++;
                                                    ?>
                                                            <a class="iqonic-port-cat" href="<?php echo get_category_link($cat->cat_ID) ?>"><?php echo esc_html($cat_name); ?></a>
                                                    <?php
                                                        }
                                                        echo '</div>';
                                                    } ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="blog-title">
                                            <a class="button-link" href="<?php echo sprintf("%s", esc_url(get_permalink($wp_query->ID))); ?>">
                                                <<?php echo esc_attr($settings['title_tag']); ?> class="blog-text powerhour-heading-title"><?php echo sprintf("%s", esc_html__(get_the_title($wp_query->ID), 'iqonic-extension')); ?></<?php echo esc_attr($settings['title_tag']); ?>>
                                            </a>
                                        </div>
                                        <?php
                                        if ($settings['show_description'] == 'block') {  ?>
                                            <div class="powerhour-blogmain">
                                                <p><?php echo sprintf("%s", get_the_excerpt($wp_query->ID)); ?></p>
                                                <?php if (!empty($settings['button_text'])) {
                                                    require  IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-btn-render-control.php';
                                                } ?>
                                            </div> <?php
                                                } ?>
                                    </div>
                                    <div class="list-inline-item blog-date">
                                        <span class="date"><?php echo  get_the_date('d'); ?></span>
                                        <span class="month"> <?php echo get_the_date('M'); ?></span>
                                    </div>
                                </div>
                        <?php
                            }
                        } ?>
                    </div>
                <?php
                }
                wp_reset_postdata();
                ?>
            </div>
            <div class="load-more-pf" style="<?php esc_html_e($display_loadmore_btn, 'iqonic-extension'); ?>">
                <a class="powerhour-button" href="#">
                    <span class="text-btn">
                        <?php
                        if (!empty($settings['loadmore_title'])) {
                            echo __($settings['loadmore_title'], 'iqonic-extension');
                        } else {
                            echo __("Load More", 'iqonic-extension');
                        } ?>
                    </span>
                </a>
            </div>
        </div> <?php

            } else if ($settings['blog_style'] == 'masonry') {
                $wp_query  = new \WP_Query($args);
                $post_per_load = $settings['posts_per_loadmore']['size'];
                ?>
        <div class="row">
            <?php
                $number = 1;
                if ($wp_query->have_posts()) {
                    while ($wp_query->have_posts()) {
                        $wp_query->the_post();
                        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");
                        $term_list = wp_get_post_terms(get_the_ID(), 'category');
                        if ($number % 2 == 0) {
                            $class = "even";
                        } else {
                            $class = "odd";
                        }
                        $powerhour_options = get_field('key_pjros12dfdfd');
                        // Thought
                        if (!empty($powerhour_options['iqonic_thought'])) {
                            $thought = $powerhour_options['iqonic_thought'];
                        }

                        // Thought Author 
                        if (!empty($powerhour_options['iqonic_thought_author'])) {
                            $thought_author = $powerhour_options['iqonic_thought_author'];
                        }

                        if (!empty($powerhour_options['thought_icon'])) {
                            $thought_image = $powerhour_options['thought_icon']['url'];
                        } ?>

                    <div class="col-lg-4 col-md-6 <?php echo $class; ?> powerhour-item <?php echo $display_data; ?>">
                        <div class="blog-main">
                            <!-- Thought Container -->
                            <div class="thought">
                                <h5 class="quote"><?php echo $thought; ?></h5>
                                <span class="quote-author"><?php echo "-By " . $thought_author; ?></span>
                                <!-- Thought image -->
                                <?php
                                if (!empty($thought_image)) { ?>
                                    <div class="thought-icon">
                                        <img src="<?php echo $thought_image; ?>" alt="">
                                    </div>
                                <?php } ?>
                            </div>
                            <!-- Blog container -->
                            <div class="blog">
                                <div class="powerhour-blog-box">
                                    <?php if (has_post_thumbnail()) { ?>
                                        <div class="powerhour-blog-image">
                                            <?php
                                            echo sprintf('<img src="%1$s" alt="iqonic-blog"/>', esc_url($full_image[0], 'iqonic-extension'));
                                            ?>
                                            <?php
                                            //post date
                                            $archive_year  = get_the_time('Y', $wp_query->ID);
                                            $archive_month = get_the_time('m', $wp_query->ID);
                                            $archive_day   = get_the_time('d', $wp_query->ID);
                                            if ($wp_query->post_date) {
                                                $date = date_create($wp_query->post_date);
                                            } ?>
                                            <div class="list-inline-item blog-date">
                                                <?php echo sprintf("%s", iqonic_blog_time_link()); ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                    <div class="powerhour-blog-details">
                                        <div class="powerhour-blog-meta">
                                            <ul class="list-inline">
                                                <li class="list-inline-item blog-author">
                                                    <?php esc_html_e("By:", 'iqonic-extension'); ?>
                                                    <a href="<?php echo get_the_author_meta($wp_query->ID) ?>" class="powerhour-user"><?php echo get_the_author($wp_query->ID); ?></a>
                                                </li>
                                                <li>
                                                    <?php
                                                    $postcat = get_the_category();
                                                    $i = 1;
                                                    if ($postcat) {
                                                        echo '<div class="blog-catgeory">';
                                                        foreach ($postcat as $cat) {
                                                            if ($i === count($postcat)) {
                                                                $cat_name = $cat->name;
                                                            } else {
                                                                $cat_name = $cat->name;
                                                            }
                                                            $i++;
                                                    ?>
                                                            <a class="iqonic-port-cat" href="<?php echo get_category_link($cat->cat_ID) ?>"><?php echo esc_html($cat_name); ?></a>
                                                    <?php }
                                                        echo '</div>';
                                                    } ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="blog-title">
                                            <a class="button-link" href="<?php echo sprintf("%s", esc_url(get_permalink($wp_query->ID))); ?>">
                                                <<?php echo esc_attr($settings['title_tag']); ?> class="blog-text powerhour-heading-title"><?php echo sprintf("%s", esc_html__(get_the_title($wp_query->ID), 'iqonic-extension')); ?></<?php echo esc_attr($settings['title_tag']); ?>>
                                            </a>
                                        </div>
                                        <div class="powerhour-blogmain">
                                            <p><?php echo wp_trim_words(get_the_excerpt(), 15, '...'); ?></p>
                                            <?php if (!empty($settings['button_text'])) {
                                                require  IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-btn-render-control.php';
                                            } ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
            <?php
                        if ($number == 3) {
                            $number = 1;
                        } else {
                            $number++;
                        }
                    }
                }
                wp_reset_postdata();
            ?>
        </div>
        <div id="more-blog" class="load-more-pf" style="<?php esc_html_e($display_loadmore_btn, 'iqonic-extension'); ?>">
            <a class="powerhour-button blog-loadmore-button" href="#">
                <span class="text-btn">
                    <?php
                    if (!empty($settings['loadmore_title'])) {
                        echo __($settings['loadmore_title'], 'iqonic-extension');
                    } else {
                        echo __("Load More", 'iqonic-extension');
                    } ?>
                </span>
            </a>
        </div>
        <?php
            } else {
                echo '<div class="row">';
                if ($settings['blog_style'] === "2") {
                    $col = 'col-lg-12' . $blog_art;
                }
                if ($settings['blog_style'] === "3") {
                    $col = 'col-lg-6 col-md-6 ';
                }
                if ($settings['blog_style'] === "4") {
                    $col = 'col-lg-4 col-md-6';
                }
                if ($settings['blog_style'] === "5") {
                    $col = 'col-lg-3 col-md-6';
                }

                if ($wp_query->have_posts()) {
                    while ($wp_query->have_posts()) {
                        $wp_query->the_post();
                        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");
                        $term_list = wp_get_post_terms(get_the_ID(), 'category'); ?>
                <div class="<?php echo esc_attr($col); ?>">
                    <div class="powerhour-blog-box">
                        <?php if (has_post_thumbnail()) { ?>
                            <div class="powerhour-blog-image">
                                <?php
                                echo sprintf('<img src="%1$s" alt="iqonic-blog"/>', esc_url($full_image[0], 'iqonic-extension'));
                                ?>
                                <?php
                                //post date
                                $archive_year  = get_the_time('Y', $wp_query->ID);
                                $archive_month = get_the_time('m', $wp_query->ID);
                                $archive_day   = get_the_time('d', $wp_query->ID);
                                if ($wp_query->post_date) {
                                    $date = date_create($wp_query->post_date);
                                } ?>
                                <div class="list-inline-item blog-date">
                                    <?php echo sprintf("%s", iqonic_blog_time_link()); ?>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="powerhour-blog-details">
                            <div class="powerhour-blog-meta">
                                <ul class="list-inline">
                                    <li class="list-inline-item blog-author">
                                        <?php esc_html_e("By:", 'iqonic-extension'); ?>
                                        <a href="<?php echo get_the_author_meta($wp_query->ID) ?>" class="powerhour-user"><?php echo get_the_author($wp_query->ID); ?></a>
                                    </li>
                                    <li>
                                        <?php
                                        $postcat = get_the_category();
                                        $i = 1;
                                        if ($postcat) {
                                            echo '<div class="blog-catgeory">';
                                            foreach ($postcat as $cat) {
                                                if ($i === count($postcat)) {
                                                    $cat_name = $cat->name;
                                                } else {
                                                    $cat_name = $cat->name;
                                                }
                                                $i++;
                                        ?>
                                                <a class="iqonic-port-cat" href="<?php echo get_category_link($cat->cat_ID) ?>"><?php echo esc_html($cat_name); ?></a>
                                        <?php }
                                            echo '</div>';
                                        } ?>
                                    </li>
                                </ul>
                            </div>
                            <div class="blog-title">
                                <a class="button-link" href="<?php echo sprintf("%s", esc_url(get_permalink($wp_query->ID))); ?>">
                                    <<?php echo esc_attr($settings['title_tag']); ?> class="blog-text powerhour-heading-title"><?php echo sprintf("%s", esc_html__(get_the_title($wp_query->ID), 'iqonic-extension')); ?></<?php echo esc_attr($settings['title_tag']); ?>>
                                </a>
                            </div>

                            <div class="powerhour-blogmain">
                                <p><?php echo sprintf("%s", get_the_excerpt($wp_query->ID)); ?></p>
                                <?php if (!empty($settings['button_text'])) {
                                    require  IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-btn-render-control.php';
                                } ?>
                            </div>
                        </div>
                    </div>
                </div>
    <?php
                    }
                }
                wp_reset_postdata();
                echo '</div>';
            }
    ?>
</div>
<?php
$tot = $wp_query->found_posts;
if ($settings['blog_style'] != '1' && $settings['pagination'] == 'yes') {
    $total_pages = $wp_query->max_num_pages;

    if ($total_pages > 1) {
        echo '<div class="powerhour-blog-pagination">';
        $current_page = max(1, get_query_var('paged'));
        echo paginate_links(array(
            'base' => get_pagenum_link(1) . '%_%',
            'format' => '/page/%#%',
            'current' => $current_page,
            'total' => $total_pages,
            'type'            => 'list',
            'prev_text'       => '<i class="fas fa-chevron-left"></i>',
            'next_text'       => '<i class="fas fa-chevron-right"></i>',
        ));
        echo '</div>';
    }
}
