<?php

namespace Iqonic\Elementor\Elements\Blog;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic-Blog', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Blog', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-slider-push';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_blog',
            [
                'label' => __('Blog Post', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'blog_style',
            [
                'label'      => __('Blog Style', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => '1',
                'options'    => [
                    '1'             => __('Blog Slider', 'iqonic-extension'),
                    '2'             => __('Blog 1 Columns', 'iqonic-extension'),
                    '3'             => __('Blog 2 Columns', 'iqonic-extension'),
                    '4'             => __('Blog 3 Columns', 'iqonic-extension'),
                    '5'             => __('Blog 4 Columns', 'iqonic-extension'),
                    'blog-grid'     => __('Blog Grid', 'iqonic-extension' ),
                    'masonry'       => __('Masonry', 'iqonic-extension' ),
                ],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'      => __('Title Tag', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'h5',
                'options'    => [
                    'h1'     => __('h1', 'iqonic-extension'),
                    'h2'     => __('h2', 'iqonic-extension'),
                    'h3'     => __('h3', 'iqonic-extension'),
                    'h4'     => __('h4', 'iqonic-extension'),
                    'h5'     => __('h5', 'iqonic-extension'),
                    'h6'     => __('h6', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'show_description',
            [
                'label'      => __('Show Description', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'block',
                'options'    => [
                    'block'  => __('Yes', 'iqonic-extension'),
                    'none'   => __('No', 'iqonic-extension'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-blogmain p' => 'display: {{VALUE}};',
                ],
                'condition' => ['blog_style!' => 'blog-masonry']
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type'  => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => __('Justified', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};',
				],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_21h1Myn3Vx5qrK29565',
            [
                'label' => __('Post Control', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label' => __('Show Pagination', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => [
                    'yes' => esc_html__('yes', 'iqonic-extension'),
                    'no' => esc_html__('no', 'iqonic-extension')
                ],
                'condition' => ['blog_style' => ['2','3','4']],
            ]
        );
        
        $this->add_control(
            'loadmore_button',
            [
                'label'    => __('Use Loadmore Button', 'iqonic-extension'),
                'type'     => Controls_Manager::SWITCHER,
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
                'default' => 'no',
                'condition' => [
					'blog_style' => 'masonry',
				],
            ]
        );
        $this->add_responsive_control(
            'posts_per_loadmore',
            [
                'label'     => __('Posts Per Load', 'iqonic-extension'),
                'type'      => Controls_Manager::SLIDER,
                'default'   => [
                    'unit'  => '%',
                    'size'  => 3,
                ],
                'condition' => [
					'blog_style' => 'masonry',
                    'loadmore_button' => 'yes'
				],
            ]
        );
        $this->add_control(
            'loadmore_title',
            [
                'label'       => __('Load More Text', 'iqonic-extension'),
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active'  => true,
                ],
                'label_block' => true,
                'condition'   => [
					'blog_style' => 'masonry',
                    'loadmore_button' => 'yes'
				],
                'default'     => __('Load More', 'iqonic-extension'),
            ]
        );
        require  IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/post-control.php';

        $this->end_controls_section();

        $this->start_controls_section(
            'owl_control_section',
            [
                'label' => __('Slider Control', 'iqonic-extension'),        
                'condition' => ['blog_style' => ['1']],
            ]
        );

        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/owl-control.php';

        $this->end_controls_section();

        require  IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-btn-controls.php';

        require  IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-colors.php';
    }
    protected function render()
    {
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Blog/render.php';
    }
}
