<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$html = '';
$icon = '';



$tabs = $this->get_settings_for_display('tabs');
$settings = $this->get_settings();
$id_int = rand(10, 100);
$this->add_render_attribute('powerhour_class', 'class', 'powerhour-accordion');

$this->add_render_attribute('powerhour_class', 'class', 'powerhour-accordion-square');

if ($settings['iqonic_has_box_shadow'] == 'yes') {

    $this->add_render_attribute('powerhour_class', 'class', 'powerhour-box-shadow');
}

if (isset($settings['title_back_active_color']) && $settings['title_back_active_color'] != $settings['content_back_color']) {
    $this->add_render_attribute('powerhour_class', 'class', 'powerhour-accordion-classic');
}



?>
<div <?php echo $this->get_render_attribute_string('powerhour_class') ?>>
    <?php
    $i = 1;
    foreach ($tabs as $index => $item) {
        if ($i == 1) {
            $show = "show";
            $style = "style=display:block";
            $adactive = "powerhour-active";
        } else {
            $style = "";
            $show = "";
            $adactive = "";
        }
    ?>

        <div class="powerhour-accordion-block <?php echo esc_attr($adactive) . '  ' . $i;  ?>">
            <div class="powerhour-accordion-title">


                        <?php if (!empty($item['tab_title'])) { ?>
                            <<?php echo $settings['title_tag']; ?> class="mb-0 accordion-title powerhour-heading-title">
                                <?php echo esc_html__($item['tab_title'], 'iqonic-extension'); ?>

                            </<?php echo $settings['title_tag']; ?>>
                        <?php } ?>


                <?php
                if ($settings['has_icon'] == 'yes') {
                    
                    echo '<div class="powerhour-icon-style">';
                    echo '<span class="active">';
                    Icons_Manager::render_icon($settings['active_icon'], ['aria-hidden' => 'true']);
                    echo '</span><span class="inactive">';
                    Icons_Manager::render_icon($settings['inactive_icon'], ['aria-hidden' => 'true']);
                    echo '</span>';
                    echo '</div>';
                }
                ?>

            </div>

            <div class="powerhour-accordion-details">

                <p class="powerhour-content-text"> <?php echo $this->parse_text_editor($item['tab_content']); ?> </p>

            </div>
        </div>
    <?php $i++;
    } ?>

</div>