<?php

namespace Iqonic\Elementor\Elements\Accordion;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic-Accordion', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Accordion', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-help-o';
    }


    protected function register_controls()
    {

        $this->start_controls_section(
            'section',
            [
                'label' => __('Accordion', 'iqonic-extension'),
            ]
        );



        $repeater = new Repeater();
        $repeater->add_control(
            'tab_title',
            [
                'label' => __('Question', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'default' => __('What is Lorem Ipsum?', 'iqonic-extension'),
                'placeholder' => __('Tab Title', 'iqonic-extension'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'tab_content',
            [
                'label' => __('Answer', 'iqonic-extension'),
                'default' => __('It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'iqonic-extension'),
                'placeholder' => __('Tab Content', 'iqonic-extension'),
                'type' => Controls_Manager::TEXTAREA,
                'show_label' => false,
            ]
        );



        $this->add_control(
            'tabs',
            [
                'label' => __('Tabs Items', 'iqonic-extension'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'tab_title' => __('Tab #1', 'iqonic-extension'),
                        'tab_content' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', 'iqonic-extension'),

                    ]

                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );
        $this->add_control(
            'has_icon',
            [
                'label' => __('Use Icon?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'iqonic_has_box_shadow',
            [
                'label' => __('Box Shadow?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'active_icon',
            [
                'label' => __('Active Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-sort-up',
                    'library' => 'solid',
                ],
                'condition' => [
                    'has_icon' => 'yes',
                ],
                'label_block' => false,
                'skin' => 'inline',
            ]
        );
        $this->add_control(
            'inactive_icon',
            [
                'label' => __('Inactive Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-sort-down',
                    'library' => 'solid',
                ],
                'condition' => [
                    'has_icon' => 'yes',
                ],
                'label_block' => false,
                'skin' => 'inline',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'      => __('Title Tag', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'h4',
                'options'    => [

                    'h1'          => __('h1', 'iqonic-extension'),
                    'h2'          => __('h2', 'iqonic-extension'),
                    'h3'          => __('h3', 'iqonic-extension'),
                    'h4'          => __('h4', 'iqonic-extension'),
                    'h5'          => __('h5', 'iqonic-extension'),
                    'h6'          => __('h6', 'iqonic-extension'),


                ],
            ]
        );


        $this->end_controls_section();



        $this->start_controls_section(
            'section_title_style',
            [
                'label' => __('Title', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );



        $this->add_control(
            'title_color',
            [
                'label' => __('Text Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-title .accordion-title' => 'color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'title_active_color',
            [
                'label' => __('Text Active Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-active .powerhour-accordion-title .accordion-title' => 'color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'title_back_color',
            [
                'label' => __('Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-title' => 'background: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'title_back_active_color',
            [
                'label' => __('Active Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-active .powerhour-accordion-title' => 'background: {{VALUE}};',

                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_content_style',
            [
                'label' => __('Content', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => __('Content Text Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-details' => 'color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'content_back_color',
            [
                'label' => __('Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-details' => 'background: {{VALUE}};',

                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_active_color',
            [
                'label' => __('Active Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block.powerhour-active .powerhour-accordion-title .active i,{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block.powerhour-active .powerhour-accordion-title i.active' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block .powerhour-accordion-title .active i path' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_inactive_color',
            [
                'label' => __('Inactive Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block .powerhour-accordion-title .inactive i,{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block .powerhour-accordion-title i.inactive' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block .powerhour-accordion-title .inactive svig path' => 'color: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'icon_back_color',
            [
                'label' => __('Icon Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block .powerhour-accordion-title .powerhour-icon-style' => 'background: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'icon_back_active_color',
            [
                'label' => __('Icon Active Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-accordion .powerhour-accordion-block .powerhour-accordion-title .powerhour-icon-style' => 'background: {{VALUE}};',

                ],
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
            'section_border_style',
            [
                'label' => __('Border', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'has_border',
            [
                'label' => __('Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'label_off',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'border_active_color',
            [
                'label' => __('Active Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block.powerhour-active' => 'border-color: {{VALUE}};',

                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'border_inactive_color',
            [
                'label' => __('Inactive Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block' => 'border-color: {{VALUE}};',

                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
            ]
        );


        $this->add_control(
            'border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-accordion .powerhour-accordion-block' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'has_border' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Accordion/render.php';
    }
}
