<?php

namespace Elementor;
$this->add_control(
    'desk_number',
    [
        'label' => __('Desktop view', 'iqonic-extension'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '3',
    ]
);

$this->add_control(
    'lap_number',
    [
        'label' => __('Laptop view', 'iqonic-extension'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '3',
    ]
);

$this->add_control(
    'tab_number',
    [
        'label' => __('Tablet view', 'iqonic-extension'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '2',
    ]
);

$this->add_control(
    'mob_number',
    [
        'label' => __('Mobile view', 'iqonic-extension'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '1',
    ]
);

$this->add_control(
    'autoplay',
    [
        'label' => __('Autoplay', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic-extension'),
            'false' => __('False', 'iqonic-extension'),
        ],
    ]
);

$this->add_control(
    'loop',
    [
        'label' => __('Loop', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic-extension'),
            'false' => __('False', 'iqonic-extension'),
        ],
    ]
);

$this->add_control(
    'slick_pagination',
    [
        'label' => __('Pagination', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic-extension'),
            'false' => __('False', 'iqonic-extension'),
        ],
    ]
);

$this->add_control(
    'dots',
    [
        'label'      => __( 'Dots', 'iqonic-extension' ),
        'type'       => Controls_Manager::SELECT,
        'default'    => 'true',
        'options'    => [
            'true'       => __( 'True', 'iqonic-extension' ),
            'false'      => __( 'False', 'iqonic-extension' ),
            
        ],
    ]
);

$this->add_control(
    'nav-arrow',
    [
        'label' => __('Arrow', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic-extension'),
            'false' => __('False', 'iqonic-extension'),
        ],
    ]
);

$this->start_controls_tabs(
    'section_tabs'
);
$this->start_controls_tab(
    'slick-normal-tab',
    [
        'label' => __('Normal','iqonic-extension')
    ]
);
$this->add_control(
    'arrow_back_normal_color',
    [
        'label' => __('Arrow Background Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial .testimonial-sliders .swiper-button-prev, .powerhour-testimonial .testimonial-sliders .swiper-button-next' => 'background: {{VALUE}};',
        ],
    ]
);
$this->add_control(
    'icon_color',
    [
        'label' => __('Icon Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial .testimonial-sliders .swiper-button-prev, .powerhour-testimonial .testimonial-sliders .swiper-button-next' => 'color: {{VALUE}};',
        ],
    ]
);
$this->add_control(
    'pagination_color',
    [
        'label' => __('InActive Pagination Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial-style-3 .slick-dots li' => 'background: {{VALUE}};',
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'slick-hover-tab',
    [
        'label' => __('Hover','iqonic-extension')
    ]
);
$this->add_control(
    'arrow_back_hover_color',
    [
        'label' => __('Arrow Background Color', 'iqonic-extension'),
        'type'  => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}.powerhour-testimonial .testimonial-sliders .swiper-button-prev, .powerhour-testimonial .testimonial-sliders .swiper-button-next:hover:hover' => 'background: {{VALUE}};',
            '{{WRAPPER}} .powerhour-testimonial .testimonial-sliders .swiper-button-prev:hover'=>'background: {{VALUE}};',
        ],
    ]
);
$this->add_control(
    'nav_arrow_icon_hover_color',
    [
        'label' => __('Icon Color', 'iqonic-extension'),
        'type'  => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial .testimonial-sliders .swiper-button-prev:hover, .powerhour-testimonial .testimonial-sliders .swiper-button-next:hover' => 'color: {{VALUE}};',
        ],
    ]
);
$this->add_control(
    'pagination__hover_color',
    [
        'label' => __('Active Pagination Color', 'iqonic-extension'),
        'type'  => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial-style-3 .slick-dots li.slick-active'=> ' background : {{VALUE}}',
        ],
    ]
);
$this->end_controls_tab();
$this->end_controls_tabs();