<?php

namespace Elementor;

$this->add_control(
    'blog_cat',
    [
        'label' => esc_html__('Category', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT2,
        'return_value' => 'true',
        'multiple' => true,
        'options' => iqonic_by_blog_cat(),
    ]
);

$this->add_responsive_control(
    'posts_per_page',
    [
        'label' => __('Posts Per Page', 'iqonic-extension'),
        'type' => Controls_Manager::SLIDER,
        'default' => [
            'unit' => '%',
            'size' => 3,
        ],
    ]
);

$this->add_control(
    'order',
    [
        'label' => __('Order By', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'ASC',
        'options' => [
            'DESC' => esc_html__('Descending', 'iqonic-extension'),
            'ASC' => esc_html__('Ascending', 'iqonic-extension')
        ],

    ]
);
