<?php

namespace Elementor;

$this->add_control(
    'desk_number',
    [
        'label' => __('Desktop view', 'iqonic-extension'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '3',
    ]
);

$this->add_control(
    'lap_number',
    [
        'label' => __('Laptop view', 'iqonic-extension'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '3',
    ]
);

$this->add_control(
    'tab_number',
    [
        'label' => __('Tablet view', 'iqonic-extension'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '2',
    ]
);

$this->add_control(
    'mob_number',
    [
        'label' => __('Mobile view', 'iqonic-extension'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],

        'label_block' => true,
        'default' => '1',
    ]
);

$this->add_control(
    'autoplay',
    [
        'label' => __('Autoplay', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic-extension'),
            'false' => __('False', 'iqonic-extension'),

        ],

    ]
);

$this->add_control(
    'loop',
    [
        'label' => __('Loop', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic-extension'),
            'false' => __('False', 'iqonic-extension'),

        ],

    ]
);

$this->add_control(
    'dots',
    [
        'label' => __('Dots', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic-extension'),
            'false' => __('False', 'iqonic-extension'),

        ],

    ]
);

$this->add_control(
    'nav-arrow',
    [
        'label' => __('Arrow', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', 'iqonic-extension'),
            'false' => __('False', 'iqonic-extension'),
        ],
    ]
);

$this->add_responsive_control(
    'margin',
    [
        'label' => __('Margin', 'iqonic-extension'),
        'type' => Controls_Manager::SLIDER,
        'default' => [
            'size' => 30,
        ],
    ]
);

$this->start_controls_tabs(
    'section-tabs'
);
// Normal Tab
$this->start_controls_tab(
    'normal-tab-controls',
    [
        'label' => __('Normal','iqonic-extension')
    ]
);
$this->add_control(
    'dot_in_active_color',
    [
        'label' => __('Dots Inactive Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .owl-dot' => 'background: {{VALUE}};',
            '{{WRAPPER}}  .slick-dots' => 'background: {{VALUE}};'
        ],
    ]
);
$this->add_control(
    'icon_color',
    [
        'label' => __('Icon Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-leftarrow svg' => 'color: {{VALUE}}',
            '{{WRAPPER}} .powerhour-rightarrow svg' => 'color: {{VALUE}}',
            '{{WRAPPER}} .sub-circle .text-btn-line-holder span' => 'color: {{VALUE}}'
        ],
    ]
);

$this->add_control(
    'arrow_back_normal_color',
    [
        'label' => __('Arrow Background Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .sub-circle' => 'background: {{VALUE}};',
            '{{WRAPPER}} .powerhour-leftarrow, .powerhour-rightarrow' => 'background: {{VALUE}};'
        ],
    ]
);

$this->end_controls_tab();

// Hover Tab
$this->start_controls_tab(
    'hover-tab-controls',
    [
        'label' => __('Hover','iqonic-extension')
    ]
);

$this->add_control(
    'dot_active_color',
    [
        'label' => __('Dots Active Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .owl-carousel .owl-dots .owl-dot.active' => 'background: {{VALUE}};',
            '{{WRAPPER}}  .owl-dot.active' => 'border-color: {{VALUE}};',
            '{{WRAPPER}}  .owl-dot' => 'border-color: {{VALUE}};',
            '{{WRAPPER}}  .owl-carousel .owl-dots .owl-dot:hover' => 'background: {{VALUE}};',
            '{{WRAPPER}}  .owl-dot:hover' => 'border-color: {{VALUE}};',
            '{{WRAPPER}}  .powerhour-testimonial-style-3 .slick-dots li.slick-active' => 'background: {{VALUE}};',
        ],
    ]
);
$this->add_control(
    'arrow_icon_hover_color',
    [
        'label' => __('Icon Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-leftarrow:hover svg' => 'color: {{VALUE}}',
            '{{WRAPPER}} .powerhour-rightarrow:hover svg' => 'color: {{VALUE}}',
        ],
    ]
);
$this->add_control(
    'arrow_back_hover_color',
    [
        'label' => __('Arrow Background Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-rightarrow:hover' => 'background: {{VALUE}} !important; ',
            '{{WRAPPER}} .powerhour-leftarrow:hover' => 'background: {{VALUE}} !important;',

        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();