<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$this->start_controls_section(
	'section_21eZ2eh1Myn3Vx5qrK29',
	[
		'label' => __('Button', 'iqonic-extension'),
	]
);


$this->add_control(
	'button_type',
	[
		'label' => __('Type', 'iqonic-extension'),
		'type' => Controls_Manager::SELECT,
		'default' => 'default',
		'options' => [
			'default' => __('Default', 'iqonic-extension'),
			'linked' => __('Linked', 'iqonic-extension'),
		],
	]
);

$this->add_control(
	'button_text',
	[
		'label' => __('Text', 'iqonic-extension'),
		'type' => Controls_Manager::TEXT,
		'dynamic' => [
			'active' => true,
		],
		'label_block' => true,
		'default' => __('Read More', 'iqonic-extension'),
	]
);

$this->add_control(
	'link_type',
	[
		'label' => __('Link Type', 'iqonic-extension'),
		'type' => Controls_Manager::SELECT,
		'default' => 'dynamic',
		'options' => [
			'dynamic' => __('Dynamic', 'iqonic-extension'),
			'custom' => __('Custom', 'iqonic-extension'),
		],
	]
);

$this->add_control(
	'dynamic_link',
	[
		'label' => esc_html__('Page List', 'iqonic-extension'),
		'type' => Controls_Manager::SELECT,
		'return_value' => 'true',
		'multiple' => true,
		'condition' => [
			'link_type' => 'dynamic',
		],
		'options' => iqonic_get_post("page"),
	]
);

$this->add_control(
	'link',
	[
		'label' => __('Link', 'iqonic-extension'),
		'type' => Controls_Manager::URL,
		'dynamic' => [
			'active' => true,
		],
		'condition' => [
			'link_type' => 'custom',
		],
		'placeholder' => __('https://your-link.com', 'iqonic-extension'),
		'default' => [
			'url' => '#',
		],
	]
);

$this->add_responsive_control(
	'align_btn',
	[
		'label' => __('Alignment', 'iqonic-extension'),
		'type' => Controls_Manager::CHOOSE,
		'options' => [
			'left' => [
				'title' => __('Left', 'iqonic-extension'),
				'icon' => 'eicon-text-align-left',
			],
			'center' => [
				'title' => __('Center', 'iqonic-extension'),
				'icon' => 'eicon-text-align-center',
			],
			'right' => [
				'title' => __('Right', 'iqonic-extension'),
				'icon' => 'eicon-text-align-right',
			],

		],
		'selectors' => [
			'{{WRAPPER}} .powerhour-btn-container' => 'text-align: {{value}};',
		],
	]
);

$this->end_controls_section();

// Button Text Style
$this->start_controls_section(
	'section_d1da6dnvYM43C71weL29',
	[
		'label' => __('Button Text Color', 'iqonic-extension'),
		'tab' => Controls_Manager::TAB_STYLE,
		'default'	=> '#02605C',
	]
);

$this->add_group_control(
	Group_Control_Typography::get_type(),
	[
		'name' => 'btn_text_typography',
		'label' => __('Typography', 'iqonic-extension'),
		'selector' => '{{WRAPPER}} .comment-respond .form-submit .submit, .contact-form-button, .powerhour-button, .elementor a.powerhour-button, .rs-button, a.powerhour-button, a.rs-button, button.powerhour-button , .powerhour-btn-link .text-btn',
	]
);

$this->start_controls_tabs('contact_tabs');
$this->start_controls_tab(
	'tabs_o8I22AKRc2bJa7BgdwHW',
	[
		'label' => __('Normal', 'iqonic-extension'),
	]
);

$this->add_control(
	'text_color',
	[
		'label' => __('Choose Color', 'iqonic-extension'),
		'type' => Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .powerhour-button .text-btn,{{WRAPPER}} .powerhour-btn-link .text-btn' => 'color: {{VALUE}};',
			'{{WRAPPER}} .powerhour-btn-link:after' => 'background: {{VALUE}};'
		],
		'default'	=> '#ffffff'
	]
);

$this->end_controls_tab();
$this->start_controls_tab(
	'tabs_1322c8M564ER8L6I65U0',
	[
		'label' => __('Hover', 'iqonic-extension'),
	]
);

$this->add_control(
	'data_hover_text',
	[
		'label' => __('Choose Color', 'iqonic-extension'),
		'type' => Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .powerhour-button:hover .text-btn' => 'color: {{VALUE}};',
			'{{WRAPPER}} .powerhour-btn-link:hover .text-btn' => 'color: {{VALUE}};'
		],
	]
);

$this->end_controls_tab();
$this->end_controls_tabs();
$this->end_controls_section();
// Button Text Style

// Background Style Start
$this->start_controls_section(
	'section_0s6Y4c68qoBcctzHf68f',
	[
		'label' => __('Button Background', 'iqonic-extension'),
		'tab' => Controls_Manager::TAB_STYLE,
		'condition' => [
			'button_type' => 'default',
		],
	]
);
$this->start_controls_tabs('_dr6Yu5af63L5yHm3cGc1');
$this->start_controls_tab(
	'tabs_z5VRHMPjDcr6wJb0a4vF',
	[
		'label' => __('Normal', 'iqonic-extension'),
	]
);

$this->add_group_control(
	Group_Control_Background::get_type(),
	[
		'name' => 'button_background_color',
		'label' => __('Background', 'iqonic-extension'),
		'types' => ['classic', 'gradient'],
		'selector' => '{{WRAPPER}} .powerhour-button',
	]
);

$this->end_controls_tab();

$this->start_controls_tab(
	'tabs_Xa27O3BGf5k23KqHfeNM',
	[
		'label' => __('Hover', 'iqonic-extension'),
	]
);

$this->add_group_control(
	Group_Control_Background::get_type(),
	[
		'name' => 'button_background_hover_color',
		'label' => __('Background', 'iqonic-extension'),
		'types' => ['classic', 'gradient'],
		'selector' => '{{WRAPPER}} .powerhour-button:hover',
	]
);
$this->end_controls_tab();
$this->end_controls_tabs();
$this->end_controls_section();
