<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$this->start_controls_section(
    'section_21eZ2eh1Myn3VrK29',
    [
        'label' => __('Main Contain', 'iqonic-extension'),
    ]
);

$this->start_controls_tabs('Iconbox_tabs');
$this->start_controls_tab(
    'tabs_jefOdwB60gC8bAl3exvb',
    [
        'label' => __('Normal', 'iqonic-extension'),
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'powerhour_iconbox_background',
        'label' => __('Background', 'iqonic-extension'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .powerhour-blog-details',
    ]
);

$this->add_control(
    'powerhour_iconbox_block_has_border',
    [
        'label' => __('Set Custom Border?', 'iqonic-extension'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'iqonic-extension'),
        'no' => __('no', 'iqonic-extension'),
    ]
);

$this->add_control(
    'powerhour_iconbox_border_style',
    [
        'label' => __('Border Style', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'condition' => ['powerhour_iconbox_block_has_border' => ['yes']],
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', 'iqonic-extension'),
            'dashed' => __('Dashed', 'iqonic-extension'),
            'dotted' => __('Dotted', 'iqonic-extension'),
            'double' => __('Double', 'iqonic-extension'),
            'outset' => __('outset', 'iqonic-extension'),
            'groove' => __('groove', 'iqonic-extension'),
            'ridge' => __('ridge', 'iqonic-extension'),
            'inset' => __('inset', 'iqonic-extension'),
            'hidden' => __('hidden', 'iqonic-extension'),
            'none' => __('none', 'iqonic-extension'),
        ],

        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-details' => 'border-style: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'powerhour_iconbox_border_color',
    [
        'label' => __('Border Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'condition' => ['powerhour_iconbox_block_has_border' => ['yes']],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-details' => 'border-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'powerhour_iconbox_border_width',
    [
        'label' => __('Border Width', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'condition' => ['powerhour_iconbox_block_has_border' => ['yes']],
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-details' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'powerhour_iconbox_border_radius',
    [
        'label' => __('Border Radius', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'condition' => ['powerhour_iconbox_block_has_border' => ['yes']],
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' => 'powerhour_iconbox_box_shadow',
        'label' => __('Box Shadow', 'iqonic-extension'),
        'selector' => '{{WRAPPER}} .powerhour-blog-details',
    ]
);

$this->add_responsive_control(
    'powerhour_iconbox_outer_padding',
    [
        'label' => __('Padding', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'powerhour_iconbox_outer_margin',
    [
        'label' => __('Margin', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-details' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);


$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_YKc3bWU0OyR6287gk966',
    [
        'label' => __('Hover', 'iqonic-extension'),
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'powerhour_iconbox_hover_background',
        'label' => __('Hover Background', 'iqonic-extension'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .powerhour-blog-box:hover .powerhour-blog-details,{{WRAPPER}} .powerhour-blog-box.acitve .powerhour-blog-details',
    ]
);

$this->add_control(
    'powerhour_iconbox_outer_block_has_border',
    [
        'label' => __('Set Custom Border?', 'iqonic-extension'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'iqonic-extension'),
        'no' => __('no', 'iqonic-extension'),
    ]
);

$this->add_control(
    'powerhour_outer_iconbox_border_style',
    [
        'label' => __('Border Style', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'condition' => ['powerhour_iconbox_outer_block_has_border' => ['yes']],
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', 'iqonic-extension'),
            'dashed' => __('Dashed', 'iqonic-extension'),
            'dotted' => __('Dotted', 'iqonic-extension'),
            'double' => __('Double', 'iqonic-extension'),
            'outset' => __('outset', 'iqonic-extension'),
            'groove' => __('groove', 'iqonic-extension'),
            'ridge' => __('ridge', 'iqonic-extension'),
            'inset' => __('inset', 'iqonic-extension'),
            'hidden' => __('hidden', 'iqonic-extension'),
            'none' => __('none', 'iqonic-extension'),

        ],

        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box:hover .powerhour-blog-details' => 'border-style: {{VALUE}};',

        ],
    ]
);

$this->add_control(
    'powerhour_outer_iconbox_border_color',
    [
        'label' => __('Border Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'condition' => ['powerhour_iconbox_outer_block_has_border' => ['yes']],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box:hover .powerhour-blog-details' => 'border-color: {{VALUE}};',
        ],


    ]
);

$this->add_control(
    'powerhour_outer_iconbox_border_width',
    [
        'label' => __('Border Width', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'condition' => ['powerhour_iconbox_outer_block_has_border' => ['yes']],
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box:hover .powerhour-blog-details' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],

    ]
);

$this->add_control(
    'powerhour_outer_iconbox_border_radius',
    [
        'label' => __('Border Radius', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'condition' => ['powerhour_iconbox_outer_block_has_border' => ['yes']],
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box:hover .powerhour-blog-details' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],

    ]
);

$this->add_group_control(
    Group_Control_Box_Shadow::get_type(),
    [
        'name' => 'powerhour_iconbox_hover_box_shadow',
        'label' => __('Box Shadow', 'iqonic-extension'),
        'selector' => '{{WRAPPER}} .powerhour-blog-box:hover .powerhour-blog-details,{{WRAPPER}} .powerhour-blog-box.acitve .powerhour-blog-details',
    ]
);


$this->add_responsive_control(
    'powerhour_iconbox_outer_hover_padding',
    [
        'label' => __('Padding', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box:hover .powerhour-blog-details' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],

    ]
);

$this->add_responsive_control(
    'powerhour_iconbox_outer_hover_margin',
    [
        'label' => __('Margin', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box:hover .powerhour-blog-details' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],

    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->end_controls_section();

$this->start_controls_section(
    'section_21eZ2ehx5qrK29',
    [
        'label' => __('Blog Title', 'iqonic-extension'),
    ]

);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'blog_title_typography',
        'label' => __('Typography', 'iqonic-extension'),
        'selector' => '{{WRAPPER}} .powerhour-blog-box .blog-title .blog-text',
    ]
);

$this->start_controls_tabs('_dr6Yu5af63L5yHm3c');
$this->start_controls_tab(
    'tabs_z5VRHMPjDcr6wJb0',
    [
        'label' => __('Normal', 'iqonic-extension'),
    ]
);

$this->add_control(
    'blog_title_color',
    [
        'label' => __('Title Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box .blog-title .blog-text' => 'color: {{VALUE}};',
        ],


    ]
);
$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_z5VRHMPjDcr',
    [
        'label' => __('Hover', 'iqonic-extension'),
    ]
);
$this->add_control(
    'blog_title_hover_color',
    [
        'label' => __('Title Hover Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box .blog-title .blog-text:hover' => 'color: {{VALUE}};',
        ],


    ]
);
$this->end_controls_tab();

$this->end_controls_tabs();

$this->end_controls_section();


$this->start_controls_section(
    'section_21eZ2ehx5q',
    [
        'label' => __('Content', 'iqonic-extension'),
        'condition' => ['show_description' => ['yes']],

    ]

);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'content_title_typography',
        'label' => __('Typography', 'iqonic-extension'),
        'selector' => '{{WRAPPER}} .powerhour-blog-box p',
    ]
);

$this->start_controls_tabs('_dr6Yu5af635yHm3c');
$this->start_controls_tab(
    'tabs_z5VRHMPjDr6wJb0',
    [
        'label' => __('Normal', 'iqonic-extension'),
    ]
);

$this->add_control(
    'content_title_color',
    [
        'label' => __('Content Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box p' => 'color: {{VALUE}};',
        ],


    ]
);
$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_z5VRHMPjD45cr',
    [
        'label' => __('Hover', 'iqonic-extension'),
    ]
);
$this->add_control(
    'content_title_hover_color',
    [
        'label' => __('Content Hover Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box p:hover' => 'color: {{VALUE}};',
        ],


    ]
);
$this->end_controls_tab();

$this->end_controls_tabs();

$this->end_controls_section();

// Post meta Style
$this->start_controls_section(
    'section_21eZ2ehx5q56',
    [
        'label' => __('Meta', 'iqonic-extension'),
    ]

);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'post_meta_typography',
        'label' => __('Typography', 'iqonic-extension'),
        'selector' => '{{WRAPPER}} .powerhour-blog-box .blog-author a, {{WRAPPER}} .powerhour-blog-box .blog-author, {{WRAPPER}} .powerhour-blog-box .powerhour-meta-box li a',
    ]
);

$this->start_controls_tabs('_dr6Yu5af635yHm3c7952');
$this->start_controls_tab(
    'tabs_z5VRHMPjD56r6wJb0',
    [
        'label' => __('Normal', 'iqonic-extension'),
    ]
);

$this->add_control(
    'post_meta_color',
    [
        'label' => __('Meta  Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box .blog-author a, {{WRAPPER}} .powerhour-blog-box .blog-author, {{WRAPPER}} .powerhour-blog-box .powerhour-meta-box li a' => 'color: {{VALUE}};'
        ],


    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_z5VRHM4PjD45cr',
    [
        'label' => __('Hover', 'iqonic-extension'),
    ]
);

$this->add_control(
    'post_meta_hover_color',
    [
        'label' => __('Meta Hover Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .powerhour-blog-box .blog-author a:hover, {{WRAPPER}} .powerhour-blog-box .powerhour-meta-box li a:hover' => 'color: {{VALUE}};',
        ],


    ]
);

$this->end_controls_tab();

$this->end_controls_tabs();

$this->end_controls_section();
