<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
$this->start_controls_section(
    'section_21eZ2eh1Myn3Vx5qrK29',
    [
        'label' => __('Button', 'iqonic-extension'),
    ]
);


$this->add_control(
    'is_default_btn',
    [
        'label' => __('Iqonic Button', 'iqonic-extension'),
        'type' => Controls_Manager::HIDDEN,
        'default' => $this->get_name(),
    ]
);

$this->add_control(
    'button_type',
    [
        'label' => __('Type', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'default',
        'options' => [
            'default' => __('Default', 'iqonic-extension'),
            'linked' => __('Linked', 'iqonic-extension'),
        ],
    ]
);

$this->add_control(
    'button_text',
    [
        'label' => __('Text', 'iqonic-extension'),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],
        'label_block' => true,
        'default' => __('Read More', 'iqonic-extension'),

    ]
);

$this->add_responsive_control(
    'alignment',
    [
        'label' => __('Alignment', 'iqonic-extension'),
        'type' => Controls_Manager::CHOOSE,
        'options' => [
            'left' => [
                'title' => __('Left', 'iqonic-extension'),
                'icon' => 'eicon-text-align-left',
            ],
            'center' => [
                'title' => __('Center', 'iqonic-extension'),
                'icon' => 'eicon-text-align-center',
            ],
            'right' => [
                'title' => __('Right', 'iqonic-extension'),
                'icon' => 'eicon-text-align-right',
            ]
        ],
        'selectors' => [
            '{{WRAPPER}} .powerhour-btn-container' => 'text-align: {{VALUE}};',
        ],
    ]
);
$this->end_controls_section();

// Button Text Style
$this->start_controls_section(
    'section_d1da6dnvYM43C71weL29',
    [
        'label' => __('Button Text', 'iqonic-extension'),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'btn_text_typography',
        'label' => __('Typography', 'iqonic-extension'),
        'selector' => '{{WRAPPER}} .powerhour-button .powerhour-text ,{{WRAPPER}} .powerhour-btn-link .text-btn',
    ]
);

$this->start_controls_tabs('contact_tabs');
$this->start_controls_tab(
    'tabs_o8I22AKRc2bJa7BgdwHW',
    [
        'label' => __('Normal', 'iqonic-extension'),
    ]
);

$this->add_control(
    'text_color',
    [
        'label' => __('Choose Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-button .powerhour-text ,{{WRAPPER}} .powerhour-btn-link .text-btn ' => 'color: {{VALUE}};',
            '{{WRAPPER}} .powerhour-btn-link:after' => 'background: {{VALUE}};'
        ],
    ]
);
$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_1322c8M564ER8L6I65U0',
    [
        'label' => __('Hover', 'iqonic-extension'),
    ]
);

$this->add_control(
    'data_hover_text',
    [
        'label' => __('Choose Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-button:hover .powerhour-text ,{{WRAPPER}} .powerhour-btn-link:hover .text-btn ' => 'color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->end_controls_section();
// Button Text Style

// Background Style Start

$this->start_controls_section(
    'section_0s6Y4c68qoBcctzHf68f',
    [
        'label' => __('Button Background', 'iqonic-extension'),
        'tab' => Controls_Manager::TAB_STYLE,
        'condition' => [
            'button_type' => 'default',
        ],
    ]
);
$this->start_controls_tabs('_dr6Yu5af63L5yHm3cGc1');
$this->start_controls_tab(
    'tabs_z5VRHMPjDcr6wJb0a4vF',
    [
        'label' => __('Normal', 'iqonic-extension'),
    ]
);
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'data_background',
        'label' => __('Background', 'iqonic-extension'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .powerhour-button ',
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_Xa27O3BGf5k23KqHfeNM',
    [
        'label' => __('Hover', 'iqonic-extension'),
    ]
);
$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name'     => 'data_hover',
        'label'    => __('Background', 'iqonic-extension'),
        'types'    => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .powerhour-button:hover',
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();
$this->add_responsive_control(
    'powerhour_button_box_padding',
    [
        'label' => __('Padding', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}}  .powerhour-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'powerhour_button_box_margin',
    [
        'label' => __('Margin', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}}  .powerhour-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],

    ]
);

$this->end_controls_section();


$this->start_controls_section(
    'section_iD8bVLQc8q83f4j5cnJk',
    [
        'label' => __('Button Border', 'iqonic-extension'),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'has_custom_border',
    [
        'label' => __('Use Custom Border?', 'iqonic-extension'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'iqonic-extension'),
        'no' => __('no', 'iqonic-extension'),
    ]
);
$this->add_control(
    'border_style',
    [
        'label' => __('Border Style', 'iqonic-extension'),
        'type' => Controls_Manager::SELECT,
        'default' => 'none',
        'options' => [
            'solid' => __('Solid', 'iqonic-extension'),
            'dashed' => __('Dashed', 'iqonic-extension'),
            'dotted' => __('Dotted', 'iqonic-extension'),
            'double' => __('Double', 'iqonic-extension'),
            'outset' => __('outset', 'iqonic-extension'),
            'groove' => __('groove', 'iqonic-extension'),
            'ridge' => __('ridge', 'iqonic-extension'),
            'inset' => __('inset', 'iqonic-extension'),
            'hidden' => __('hidden', 'iqonic-extension'),
            'none' => __('none', 'iqonic-extension'),

        ],
        'condition' => ['has_custom_border' => 'yes'],

        'selectors' => [
            '{{WRAPPER}} .powerhour-button, {{WRAPPER}} .circle-box' => 'border-style: {{VALUE}};',

        ],
    ]
);
$this->add_control(
    'data_border',
    [
        'label' => __('Border Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-button, {{WRAPPER}} .circle-box' => 'border-color: {{VALUE}};',
        ],
        'condition' => ['has_custom_border' => 'yes'],

    ]
);
$this->add_control(
    'data_hover_border_outline',
    [
        'label' => __('Hover Border Color', 'iqonic-extension'),
        'type' => Controls_Manager::COLOR,

        'selectors' => [
            '{{WRAPPER}} .powerhour-button:hover, {{WRAPPER}} .circle-box:hover' => 'border-color: {{VALUE}};',
        ],
        'condition' => ['has_custom_border' => 'yes'],

    ]
);




$this->add_control(
    'border_width',
    [
        'label' => __('Border Width', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-button, {{WRAPPER}} .circle-box' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => ['has_custom_border' => 'yes'],

    ]
);

$this->add_control(
    'border_radius',
    [
        'label' => __('Border Radius', 'iqonic-extension'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-button , {{WRAPPER}} .circle-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => ['has_custom_border' => 'yes'],

    ]
);
$this->end_controls_section();
// Border Style Start