<?php

// Register Testimonial type custom post
add_action('init', 'iqonic_testimonial_gallery');
function iqonic_testimonial_gallery()
{
    $labels = array(
        'name'                  => esc_html__('Testimonial', 'iqonic-extension'),
        'singular_name'         => esc_html__('Testimonial', 'iqonic-extension'),
        'featured_image'        => esc_html__('Photo', 'iqonic-extension'),
        'set_featured_image'    => esc_html__('Set Photo', 'iqonic-extension'),
        'remove_featured_image' => esc_html__('Remove Photo', 'iqonic-extension'),
        'use_featured_image'    => esc_html__('Use as Photo', 'iqonic-extension'),
        'menu_name'             => esc_html__('Testimonial', 'iqonic-extension'),
        'name_admin_bar'        => esc_html__('Testimonial', 'iqonic-extension'),
        'add_new'               => esc_html__('Add New', 'iqonic-extension'),
        'add_new_item'          => esc_html__('Add New Testimonial', 'iqonic-extension'),
        'new_item'              => esc_html__('New Testimonial', 'iqonic-extension'),
        'edit_item'             => esc_html__('Edit Testimonial', 'iqonic-extension'),
        'view_item'             => esc_html__('View Testimonial', 'iqonic-extension'),
        'all_items'             => esc_html__('All Testimonial', 'iqonic-extension'),
        'search_items'          => esc_html__('Search Testimonial', 'iqonic-extension'),
        'parent_item_colon'     => esc_html__('Parent Testimonial:', 'iqonic-extension'),
        'not_found'             => esc_html__('No Testimonial found.', 'iqonic-extension'),
        'not_found_in_trash'    => esc_html__('No Testimonial found in Trash.', 'iqonic-extension')
    );

    $args = array(
        'labels' => $labels,
        'public' => true,
        'publicly_queryable' => true,
        'show_ui' => true,
        'show_in_menu' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'testimonial'),
        'capability_type' => 'post',
        'has_archive' => true,
        'hierarchical' => false,
        'menu_position' => null,
        'menu_icon' => 'dashicons-format-gallery',
        'supports' => array('title', 'editor', 'thumbnail')
    );

    register_post_type('testimonial', $args);
}