<?php
// Register Testimonial custom post type
add_action('init', 'iqonic_service');
function iqonic_service()
{
    $labels = array(
        'name'                  => esc_html__('Service', 'iqonic-extension'),
        'singular_name'         => esc_html__('Service','iqonic-extension'),
        'featured_image'        => esc_html__('Photo', 'iqonic-extension'),
        'set_featured_image'    => esc_html__('Set Photo', 'iqonic-extension'),
        'remove_featured_image' => esc_html__('Remove Photo', 'iqonic-extension'),
        'use_featured_image'    => esc_html__('Use as Photo', 'iqonic-extension'),
        'menu_name'             => esc_html__('Service','iqonic-extension'),
        'name_admin_bar'        => esc_html__('Service', 'iqonic-extension'),
        'add_new'               => esc_html__('Add New', 'iqonic-extension'),
        'add_new_item'          => esc_html__('Add New Service', 'iqonic-extension'),
        'new_item'              => esc_html__('New Service', 'iqonic-extension'),
        'edit_item'             => esc_html__('Edit Service', 'iqonic-extension'),
        'view_item'             => esc_html__('View Service', 'iqonic-extension'),
        'all_items'             => esc_html__('All Service', 'iqonic-extension'),
        'search_items'          => esc_html__('Search Service', 'iqonic-extension'),
        'parent_item_colon'     => esc_html__('Parent Service:', 'iqonic-extension'),
        'not_found'             => esc_html__('No Service found.', 'iqonic-extension'),
        'not_found_in_trash'    => esc_html__('No Service found in Trash.', 'iqonic-extension')
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'service'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-editor-insertmore',
        'supports'           => array('title', 'editor', 'thumbnail', 'excerpt')
    );
    register_post_type('Service', $args);
}
// Custom taxonomy
add_action('after_setup_theme', 'iqonic_service_custom_taxonomy');
function iqonic_service_custom_taxonomy()
{
    $labels = '';

    register_taxonomy(
        'service-categories',
        'service',
        array(
            'label' => esc_html__('Service Category', 'iqonic-extension'),
            'rewrite' => true,
            'hierarchical' => true,
        )
    );
}