<?php
// Register Portfolio CPT
add_action('init', 'iqonic_portfolio',0);
function iqonic_portfolio()
{
    $labels = array(
        'name'                  => esc_html__('Portfolio','iqonic-extension'),
        'singular_name'         => esc_html__('Portfolio','iqonic-extension'),
        'featured_image'        => esc_html__('Photo', 'iqonic-extension'),
        'set_featured_image'    => esc_html__('Set Photo', 'iqonic-extension'),
        'remove_featured_image' => esc_html__('Remove Photo', 'iqonic-extension'),
        'use_featured_image'    => esc_html__('Use as Photo', 'iqonic-extension'),
        'menu_name'             => esc_html__('Portfolio', 'admin menu', 'iqonic-extension'),
        'name_admin_bar'        => esc_html__('Portfolio', 'add new on admin bar', 'iqonic-extension'),
        'add_new'               => esc_html__('Add New', 'Portfolio', 'iqonic-extension'),
        'add_new_item'          => esc_html__('Add New Portfolio', 'iqonic-extension'),
        'new_item'              => esc_html__('New Portfolio', 'iqonic-extension'),
        'edit_item'             => esc_html__('Edit Portfolio', 'iqonic-extension'),
        'view_item'             => esc_html__('View Portfolio', 'iqonic-extension'),
        'all_items'             => esc_html__('All Portfolio', 'iqonic-extension'),
        'search_items'          => esc_html__('Search Portfolio', 'iqonic-extension'),
        'parent_item_colon'     => esc_html__('Parent Portfolio:', 'iqonic-extension'),
        'not_found'             => esc_html__('No Portfolio found.', 'iqonic-extension'),
        'not_found_in_trash'    => esc_html__('No Portfolio found in Trash.', 'iqonic-extension')
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'portfolio'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => null,
        'menu_icon'          => 'dashicons-grid-view',
        'supports'           => array('title', 'editor', 'thumbnail', 'excerpt', 'author', 'comments' , 'revision' , 'custom-fields')
    );

    register_post_type('portfolio', $args);
}

// Custom taxonomy
add_action('after_setup_theme', 'iqonic_portfolio_taxonomy');
function  iqonic_portfolio_taxonomy()
{
    register_taxonomy(
        'portfolio_categories',
        'portfolio',
        array(
            'label' => esc_html__('Category', 'iqonic-extension'),
            'rewrite' => true,
            'hierarchical' => true,
        )
    );
}

add_action('init', 'iqonic_portfolio_tag_taxonomies', 0);

//create two tags for the post type "tag"
function iqonic_portfolio_tag_taxonomies()
{
    $labels = array(
        'name' => esc_html__('Tags', 'iqonic-extension'),
        'singular_name' => esc_html__('Tag', 'iqonic-extension'),
        'search_items' =>  esc_html__('Search Tags', 'iqonic-extension'),
        'popular_items' => esc_html__('Popular Tags', 'iqonic-extension'),
        'all_items' => esc_html__('All Tags', 'iqonic-extension'),
        'parent_item' => null,
        'parent_item_colon' => null,
        'edit_item' => esc_html__('Edit Tag', 'iqonic-extension'),
        'update_item' => esc_html__('Update Tag', 'iqonic-extension'),
        'add_new_item' => esc_html__('Add New Tag', 'iqonic-extension'),
        'new_item_name' => esc_html__('New Tag Name', 'iqonic-extension'),
        'separate_items_with_commas' => esc_html__('Separate tags with commas', 'iqonic-extension'),
        'add_or_remove_items' => esc_html__('Add or remove tags', 'iqonic-extension'),
        'choose_from_most_used' => esc_html__('Choose from the most used tags', 'iqonic-extension'),
        'menu_name' => esc_html__('Tags', 'iqonic-extension'),
    );

    register_taxonomy('portfolio_tags', 'portfolio', array(
        'hierarchical' => false,
        'labels' => $labels,
        'show_ui' => true,
        'update_count_callback' => '_update_post_term_count',
        'query_var' => true,
        'rewrite' => array('slug' => 'portfolio_tags'),
    ));
}

