<?php

namespace Iqonic\Custom_Post\Metabox;

class Gallery
{
    public function __construct()
    {
        add_action('admin_menu', [$this, 'iqonic_meta_box_add']);
        add_action('save_post_portfolio', [$this, 'iqonic_save_portfolio']);
        add_action('admin_enqueue_scripts', [$this, 'iqonic_enqueue_admin_script']);
    }
    public function iqonic_enqueue_admin_script($hook)
    {
        if (('post.php' == $hook || 'post-new.php' == $hook) && "portfolio" == get_post_type()) {
            wp_enqueue_script('jquery-ui-core');
            wp_enqueue_script('jquery-ui-widget');
            wp_enqueue_script('jquery-ui-sortable');

            if (!did_action('wp_enqueue_media'))
                wp_enqueue_media();
            wp_enqueue_script('iqonic-gallery-mb', IQONIC_EXTENSION_PLUGIN_URL . 'includes/assets/js/admin-gallery-metabox.js', array(), '1.0');
        }
    }
    function iqonic_meta_box_add()
    {
        add_meta_box(
            'iqonic-gallery-mb', // meta box ID
            'Gallery', // meta box title
            [$this, 'iqonic_print_box'], // callback function that prints the meta box HTML 
            'portfolio', // post type where to add it
            'side', // priority
            'low' // position
        );
    }
    function iqonic_print_box($post)
    {
        $meta_key = 'iqonic_gallery_selected_images';
        wp_nonce_field('iqonic_gallery_meta_box_nonce', 'gallery_meta_box_nonce');
        echo $this->iqonic_gallery_field($meta_key, get_post_meta($post->ID, $meta_key, true));
    }
    function iqonic_gallery_field($name, $value = '')
    {

        $html = '<div><ul class="iqonic_gallery_mtb" style="display: flex;align-items: center;flex-wrap: wrap;margin: 0 -5px;">';
        /* array with image IDs for hidden field */
        $hidden = array();


        if ($images = get_posts(array(
            'post_type' => 'attachment',
            'orderby' => 'post__in', /* we have to save the order */
            'order' => 'ASC',
            'post__in' => explode(',', $value), /* $value is the image IDs comma separated */
            'numberposts' => -1,
            'post_mime_type' => 'image'
        ))) {

            foreach ($images as $image) {
                $hidden[] = $image->ID;
                $image_src = wp_get_attachment_image_src($image->ID, array(80, 80));
                $html .= '<li style="width:50%; position: relative;margin-bottom: 7px;" data-id="' . $image->ID .  '"><span style=" padding: 0 7px;display: block;"><img style="width:100%;height:100px;" src="' . $image_src[0] . '"/></span><a style="position: absolute;top: 5px;left: auto;right: 15px;border: 1px solid;padding: 0 5px;border-radius: 50%;" href="#" class="iqonic_gallery_remove" >&times;</a></li>';
            }
        }

        $html .= '</ul><div style="clear:both"></div></div>';
        $html .= '<input type="hidden" name="' . $name . '" value="' . join(',', $hidden) . '" /><a href="#" class="button iqonic_upload_gallery_button">Add Images</a>';

        return $html;
    }
    function iqonic_save_portfolio($post_id)
    {
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return $post_id;
        }
        
        if (!isset($_POST['gallery_meta_box_nonce']) || !wp_verify_nonce($_POST['gallery_meta_box_nonce'], 'iqonic_gallery_meta_box_nonce')) return;

        $meta_key = 'iqonic_gallery_selected_images';
        update_post_meta($post_id, $meta_key, $_POST[$meta_key]);

        return $post_id;
    }
}