<?php

namespace Iqonic\Acf;

class Portfolio
{
    public function __construct()
    {
        $this->set_testimonial_options();
    }

    public function set_testimonial_options()
    {
        if (function_exists('acf_add_local_field_group')) {
            // Page Options
            acf_add_local_field_group(array(
                'key' => 'portfolio_group',
                'title' => 'Portfolio Details',
                'fields' => array(
                    array(
                        'key' => 'field_portfolio_details_tab',
                        'label' => 'Portfolio Details',
                        'name' => 'banner',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'key_pjros12gdfgd',
                        'label' => '',
                        'name' => 'member_detail_group',
                        'type' => 'group',
                        'instructions' => '',
                        'required' => 0,

                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => 'table',
                        'sub_fields' => array(

                            array(
                                'key' => 'field_client_name',
                                'label' => 'Client Name',
                                'name' => 'iqonic_portfolio_client',
                                'type' => 'text',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50%',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'message' => '',
                                'default_value' => 'client',
                                'ui' => 1,
                                'ui_on_text' => '',
                                'ui_off_text' => '',
                            ),   

                            array(
                                'key' => 'field_project_address',
                                'label' => 'Portfolio Address',
                                'name' => 'iqonic_portfolio_address',
                                'type' => 'text',
                                'instructions' => '',
                                'default_value' => '4021 Shady Pointe Row
                                Greenwood, Indiana(IN), 46143',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '50%',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'message' => '',
                                'ui' => 1,
                                'ui_on_text' => '',
                                'ui_off_text' => '',
                            ),
                            array(
                                'key' => 'field_breadcrumb',
                                'label' => 'Display Breadcrumb',
                                'name' => 'iqonic_breadcrumb',
                                'type' => 'button_group',
                                'instructions' => '',
                                'required' => 0,
                                'conditional_logic' => 0,
                                'wrapper' => array(
                                    'width' => '25%',
                                    'class' => '',
                                    'id' => '',
                                ),
                                'message' => '',
                                'choices' => array(
                                    'yes' => 'yes',
                                    'no' => 'no',
                                ),
                            ),
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => 'portfolio',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));
        }
    }
}
